/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.mappingcores;

import com.google.common.collect.Sets;
import de.julielab.gene.candidateretrieval.CandidateRetrieval;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.DocumentMappingResult;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.MentionMappingResult;
import de.julielab.geneexpbase.genemodel.PosTag;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.composites.GeneCompositeNameResolver;
import de.julielab.genemapper.disambig.ContextRanker;
import de.julielab.genemapper.disambig.DypsisDocumentDisambiguationData;
import de.julielab.genemapper.disambig.wikipedia.WikipediaEntityClassDecisionBear;
import de.julielab.genemapper.evaluation.tools.Stats;
import de.julielab.genemapper.filtering.families.GeneMentionFamilyFeatureSetter;
import de.julielab.genemapper.mappingcores.DypsisCandidateSetter;
import de.julielab.genemapper.mappingcores.MappingCore;
import de.julielab.genemapper.utils.GeneMapperException;
import de.julielab.speciesassignment.GeneSpeciesAssigner;
import de.julielab.speciesassignment.SpeciesAssignmentException;
import de.julielab.speciesassignment.services.SpeciesHintSetter;
import de.julielab.speciesassignment.spi.SpeciesAssignmentFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DypsisMappingCore
implements MappingCore {
    public static final Logger filterLog = LoggerFactory.getLogger(DypsisMappingCore.class.getCanonicalName() + ".filter");
    public static final Logger timerLog = LoggerFactory.getLogger(DypsisMappingCore.class.getCanonicalName() + ".timer");
    private static final Logger log = LoggerFactory.getLogger(DypsisMappingCore.class);
    private final CandidateRetrieval candidateRetrieval;
    private final TermNormalizer normalizer;
    private final DypsisCandidateSetter candidateSetter;
    private final GeneCompositeNameResolver geneCompositeNameResolver;
    private final GeneSpeciesAssigner speciesAssigner;
    private final SpeciesAssignmentFilter assignmentFilter;
    private final WikipediaEntityClassDecisionBear bear;
    private boolean omitCandidateSetting;

    @Inject
    public DypsisMappingCore(TermNormalizer normalizer, CandidateRetrieval candidateRetrieval, DypsisCandidateSetter candidateSetter, WikipediaEntityClassDecisionBear decisionBear, GeneCompositeNameResolver geneCompositeNameResolver, GeneSpeciesAssigner speciesAssigner, SpeciesAssignmentFilter assignmentFilter) throws GeneMapperException {
        this.normalizer = normalizer;
        this.candidateRetrieval = candidateRetrieval;
        this.candidateSetter = candidateSetter;
        this.bear = decisionBear;
        this.geneCompositeNameResolver = geneCompositeNameResolver;
        this.speciesAssigner = speciesAssigner;
        this.assignmentFilter = assignmentFilter;
    }

    public DypsisCandidateSetter getCandidateSetter() {
        return this.candidateSetter;
    }

    public void setOmitCandidateSetting(boolean omitCandidateSetting) {
        this.omitCandidateSetting = omitCandidateSetting;
    }

    public void saveCandidateSetter(File destination, Parameters parameters) {
        log.info("Storing candidate setter parameters and model to {}", (Object)destination);
        this.candidateSetter.save(destination, parameters);
    }

    public void loadCandidateSetter(File source) throws IOException, ClassNotFoundException {
        log.info("Loading candidate setter parameters and models from {}", (Object)source);
        this.candidateSetter.load(source);
    }

    @Override
    public DocumentMappingResult map(GeneDocument document) throws GeneMapperException {
        return this.map(document, null, new Stats());
    }

    public void saveParameter(File destination) {
    }

    public void loadParameters(File soruce) {
    }

    @Override
    public DocumentMappingResult map(GeneDocument document, Parameters parameterMap, Stats stats) throws GeneMapperException {
        try {
            this.assignSpecies(document, parameterMap);
        }
        catch (SpeciesAssignmentException e2) {
            throw new GeneMapperException(e2);
        }
        this.selectGenes(document, stats, parameterMap);
        document.agglomerateByAcronyms();
        document.agglomerateByCoreference();
        document.agglomerateByNames(true);
        GeneMentionFamilyFeatureSetter.setFamilyNameFeatures(document);
        DocumentMappingResult result = new DocumentMappingResult(document.getId());
        if (!this.omitCandidateSetting) {
            this.candidateSetter.setCandidates(document, parameterMap, stats);
            this.applyRejectionThresholds(document, parameterMap);
            boolean contextRankingTrainMode = parameterMap != null && parameterMap.getBoolean(Configuration.dot("disambiguation", "train_mode"), false);
            boolean mapGenesets = parameterMap.getString(Configuration.dot("candidate_retrieval", "mapping_mode")).equals("genesets");
            if (parameterMap.getBoolean("do_disambiguation", false)) {
                DypsisDocumentDisambiguationData disambiguationData = new DypsisDocumentDisambiguationData();
                disambiguationData.setDocument(document);
                disambiguationData.setStats(stats);
                parameterMap.put(Configuration.dot("candidate_retrieval", "algorithm"), this.candidateSetter.getModelParameters().get(Configuration.dot("candidate_retrieval", "algorithm")));
                parameterMap.put(Configuration.dot("candidate_retrieval", "use_token_features"), this.candidateSetter.getModelParameters().getBoolean(Configuration.dot("candidate_retrieval", "use_token_features"), true));
            } else if (!mapGenesets) {
                for (GeneMention gm2 : document.getNonRejectedGenesIterable()) {
                    MentionMappingResult mmr = gm2.getMentionMappingResult();
                    mmr.tax2finalRankedCandidates = mmr.tax2lexicallyRerankedCandidates;
                    assert (mmr.tax2finalRankedCandidates.entrySet().stream().noneMatch(e -> ((List)e.getValue()).isEmpty())) : "The gene " + gm2 + " is not rejected but has an empty candidate list: " + gm2.getMentionMappingResult().tax2finalRankedCandidates;
                    mmr.tax2finalRankedCandidates.values().stream().flatMap(Collection::stream).forEach(sh -> sh.setOverallScore(sh.getLexicalScore()));
                }
            } else {
                for (GeneSet gs : document.getGeneSets()) {
                    MentionMappingResult mmr = gs.getMentionMappingResult();
                    if (mmr == null || mmr.isRejected()) continue;
                    mmr.tax2finalRankedCandidates = mmr.tax2lexicallyRerankedCandidates;
                    assert (mmr.tax2finalRankedCandidates.entrySet().stream().noneMatch(e -> ((List)e.getValue()).isEmpty())) : "The gene set " + gs + " has an empty candidate list: " + mmr.tax2finalRankedCandidates;
                    mmr.tax2finalRankedCandidates.values().stream().flatMap(Collection::stream).forEach(sh -> sh.setOverallScore(sh.getLexicalScore()));
                    for (GeneMention gm3 : gs) {
                        MentionMappingResult gmMmr = gm3.getMentionMappingResult();
                        gmMmr.tax2finalRankedCandidates = gmMmr.tax2lexicallyRerankedCandidates;
                        assert (gmMmr.tax2finalRankedCandidates.entrySet().stream().noneMatch(e -> ((List)e.getValue()).isEmpty())) : "The gene " + gm3 + " has an empty candidate list: " + gmMmr.tax2finalRankedCandidates;
                        gmMmr.tax2finalRankedCandidates.values().stream().flatMap(Collection::stream).forEach(sh -> sh.setOverallScore(sh.getLexicalScore()));
                    }
                    this.selectGsMmr(gs);
                    for (GeneMention gm3 : gs) {
                        gm3.setMentionMappingResult(gs.getMentionMappingResult());
                    }
                }
            }
            this.resolveGeneSetContradictions(document);
            result.mentionResults = document.getGenes().map(GeneMention::getMentionMappingResult).collect(Collectors.toList());
        }
        document.getGenes().filter(gm -> gm.getMentionMappingResult() == null).forEach(gm -> gm.reject(MentionMappingResult.RejectReason.NOT_MAPPED));
        return result;
    }

    private void rejectGenesWithFamilySpecificType(GeneDocument document) {
        for (GeneMention gm : document.getNonRejectedGenesIterable()) {
            if (gm.getSpecificType() == GeneMention.SpecificType.GENE) continue;
            gm.reject(MentionMappingResult.RejectReason.IS_FAMILY);
        }
    }

    private void applyRejectionThresholds(GeneDocument document, Parameters parameterMap) {
        double rankingThresholdExact = parameterMap.getDouble(Configuration.dot("rejection", "ranking_score", "exactmatch", "threshold"), 0.0);
        double rankingThresholdApprox = parameterMap.getDouble(Configuration.dot("rejection", "ranking_score", "approxmatch", "threshold"), 0.0);
        double nerConfidenceThresholdExact = parameterMap.getDouble(Configuration.dot("rejection", "ner_confidence", "exactmatch", "threshold"), 0.0);
        double nerConfidenceThresholdApprox = parameterMap.getDouble(Configuration.dot("rejection", "ner_confidence", "approxmatch", "threshold"), 0.0);
        for (GeneMention gm : document.getNonRejectedGenesIterable()) {
            assert (gm.getMentionMappingResult().tax2lexicallyRerankedCandidates.entrySet().stream().noneMatch(e -> ((List)e.getValue()).isEmpty())) : "The gene " + gm + " is not rejected but has an empty lexically ranked candidate list: " + gm.getMentionMappingResult().tax2lexicallyRerankedCandidates;
            double effectiveRankingThreshold = rankingThresholdExact;
            double effectiveConfidenceThreshold = nerConfidenceThresholdExact;
            boolean hasExactCandidateMatch = gm.hasExactCandidateMatch();
            if (!hasExactCandidateMatch) {
                effectiveRankingThreshold = rankingThresholdApprox;
                effectiveConfidenceThreshold = nerConfidenceThresholdApprox;
            }
            if (gm.getSpecificType() == GeneMention.SpecificType.GENE && gm.getSpecificTypeConfidence() < effectiveConfidenceThreshold) {
                gm.reject(MentionMappingResult.RejectReason.MENTION_SCORE_BELOW_THRESHOLD);
                filterLog.debug("Rejecting GeneMention [DocId {}, ExactMatch {}]{}: SpecificType GENE, confidence {}, threshold {}", gm.getDocId(), hasExactCandidateMatch, gm.getText(), gm.getSpecificTypeConfidence(), effectiveConfidenceThreshold);
            } else if (gm.getSpecificType() != GeneMention.SpecificType.GENE && 1.0 - gm.getSpecificTypeConfidence() < effectiveConfidenceThreshold) {
                assert (gm.getSpecificType() == GeneMention.SpecificType.FAMILYNAME);
                gm.reject(MentionMappingResult.RejectReason.MENTION_SCORE_BELOW_THRESHOLD);
                filterLog.debug("Rejecting GeneMention [{}, ExactMatch {}]{}: SpecificType FAMILY, confidence {}, threshold {}", gm.getDocId(), hasExactCandidateMatch, gm.getText(), gm.getSpecificTypeConfidence(), effectiveConfidenceThreshold);
            } else {
                for (String taxId : gm.getMentionMappingResult().tax2lexicallyRerankedCandidates.keySet()) {
                    List<SynHit> candidates4taxId = gm.getMentionMappingResult().tax2lexicallyRerankedCandidates.get(taxId);
                    Iterator<SynHit> candIt = candidates4taxId.iterator();
                    while (candIt.hasNext()) {
                        SynHit candidate = candIt.next();
                        if (!(candidate.getLexicalScore() < effectiveRankingThreshold)) continue;
                        candIt.remove();
                        filterLog.debug("Filtering SynHit [{}]{} for GeneMention [DocId {}, ExactMatch: {}]{}: Lexical score {}, threshold {}", candidate.getId(), candidate.getSynonym(), gm.getDocId(), candidate.isExactMatch(), gm.getText(), candidate.getLexicalScore(), effectiveRankingThreshold);
                    }
                    if (!candidates4taxId.isEmpty()) continue;
                    gm.reject(taxId, MentionMappingResult.RejectReason.DISAMBIGUATION_BELOW_THRESHOLD);
                }
                assert (gm.getMentionMappingResult().tax2lexicallyRerankedCandidates.entrySet().stream().noneMatch(e -> ((List)e.getValue()).isEmpty())) : "The gene " + gm + " is not rejected but has an empty lexically ranked candidate list: " + gm.getMentionMappingResult().tax2lexicallyRerankedCandidates;
            }
            assert (gm.getMentionMappingResult().tax2lexicallyRerankedCandidates.entrySet().stream().noneMatch(e -> ((List)e.getValue()).isEmpty())) : "The gene " + gm + " is not rejected but has an empty lexically ranked candidate list: " + gm.getMentionMappingResult().tax2lexicallyRerankedCandidates;
        }
    }

    private void fpFilterExperiments(GeneDocument document) {
        for (GeneMention gm : document.getGenesIterable()) {
            if (gm.isRejected()) continue;
            if (gm.getSpecificType() == GeneMention.SpecificType.FAMILYNAME) {
                gm.reject(MentionMappingResult.RejectReason.IS_FAMILY);
            }
            if (!gm.getText().matches(".*(complex|sites?|-like receptors?|motifs?).*")) continue;
            gm.reject(MentionMappingResult.RejectReason.IS_NON_GENE_WORD);
        }
    }

    private void fpFilter1(GeneDocument document) {
        for (GeneMention gm : document.getGenesIterable()) {
            if (!gm.getFamilyFeatures().isEmpty() || (gm.getSpecificType() == GeneMention.SpecificType.FAMILYNAME || gm.getSpecificType() == GeneMention.SpecificType.DOMAINMOTIF) && gm.getSpecificTypeConfidence() > 0.99999999999) {
                gm.setSpecificType(GeneMention.SpecificType.FAMILYNAME);
                for (String string : gm.getTaxonomyIds()) {
                    gm.reject(string, MentionMappingResult.RejectReason.IS_FAMILY);
                }
            } else {
                gm.setSpecificType(GeneMention.SpecificType.GENE);
            }
            Set<Map.Entry<Range<Integer>, String>> overlappingNps = document.getOverlappingChunks(gm.getOffsets(), "ChunkNP");
            for (Map.Entry<Range<Integer>, String> np : overlappingNps) {
                String coveredText = document.getCoveredText(np.getKey());
                if (!coveredText.contains("a recombinant")) continue;
                gm.reject(MentionMappingResult.RejectReason.IS_NON_GENE_WORD);
            }
            Collection<PosTag> collection = document.getOverlappingPosTags(gm.getOffsets());
            if (collection.size() == 1 && collection.iterator().next().getTag().equals("NNS")) {
                gm.reject(MentionMappingResult.RejectReason.IS_GROUP);
            }
            if (!gm.isRejected() && document.getOverlappingNonGenePhrases(gm.getOffsets()).getMaximum() > 0) {
                gm.reject(MentionMappingResult.RejectReason.IS_NON_GENE_WORD);
            }
            if (gm.isRejected()) continue;
            GeneMention.SpecificType specificType = this.bear.lookupEntityType(gm);
            if (specificType != GeneMention.SpecificType.UNKNOWN && specificType != GeneMention.SpecificType.GENE) {
                MentionMappingResult.RejectReason reason;
                if (specificType == GeneMention.SpecificType.FAMILYNAME) {
                    reason = MentionMappingResult.RejectReason.IS_FAMILY;
                } else if (specificType == GeneMention.SpecificType.GROUP) {
                    reason = MentionMappingResult.RejectReason.IS_GROUP;
                } else if (specificType == GeneMention.SpecificType.NO_GENE) {
                    reason = MentionMappingResult.RejectReason.IS_NON_GENE_WORD;
                } else if (specificType == GeneMention.SpecificType.COMPLEX) {
                    reason = MentionMappingResult.RejectReason.IS_COMPLEX;
                } else {
                    throw new IllegalArgumentException("Unhandled specific type from wikipedia decision bear");
                }
                gm.reject(reason);
                gm.setSpecificType(specificType);
                gm.freezeSpecificType();
                continue;
            }
            if (specificType != GeneMention.SpecificType.GENE) continue;
            gm.setSpecificType(GeneMention.SpecificType.GENE);
            gm.freezeSpecificType();
        }
    }

    private void rankByScoreSum(GeneSet gs) {
        HashMap<String, Double> id2scoreSum = new HashMap<String, Double>();
        HashSet<String> alreadySeenGmSurfaceForms = new HashSet<String>();
        for (GeneMention gm : gs.getNonRejectedGenesIterable()) {
            if (!alreadySeenGmSurfaceForms.add(gm.getNormalizedText())) continue;
            Map<String, List<SynHit>> tax2finalRankedCandidates = gm.getMentionMappingResult().tax2finalRankedCandidates;
            for (String tax : gm.getTaxonomyIds()) {
                List<SynHit> candidates4tax = tax2finalRankedCandidates.get(tax);
                boolean listHasExact = gm.hasExactMatchInTax(tax);
                for (SynHit sh2 : candidates4tax) {
                    if (listHasExact && !sh2.isExactMatch()) continue;
                    id2scoreSum.merge(sh2.getId(), sh2.getLexicalScore(), Double::sum);
                }
            }
        }
        gs.getNonRejectedGenes().map(GeneMention::getMentionMappingResult).flatMap(mmr -> mmr.tax2finalRankedCandidates.values().stream()).flatMap(Collection::stream).filter(sh -> id2scoreSum.containsKey(sh.getId())).forEach(sh -> sh.setOverallScore((Double)id2scoreSum.get(sh.getId())));
        for (GeneMention gm : gs.getNonRejectedGenesIterable()) {
            Map<String, List<SynHit>> tax2candidates = gm.getMentionMappingResult().tax2finalRankedCandidates;
            for (String tax : tax2candidates.keySet()) {
                tax2candidates.get(tax).sort(Comparator.comparingDouble(SynHit::getOverallScore).reversed());
            }
        }
    }

    private void rankByScoreSum(GeneDocument document) {
        Map<String, Double> id2scoreSum = document.getNonRejectedGenes().map(GeneMention::getMentionMappingResult).flatMap(mmr -> mmr.tax2finalRankedCandidates.values().stream()).flatMap(Collection::stream).collect(Collectors.toMap(SynHit::getId, SynHit::getLexicalScore, Double::sum));
        document.getNonRejectedGenes().map(GeneMention::getMentionMappingResult).flatMap(mmr -> mmr.tax2finalRankedCandidates.values().stream()).flatMap(Collection::stream).forEach(sh -> sh.setOverallScore((Double)id2scoreSum.get(sh.getId())));
        for (GeneMention gm : document.getNonRejectedGenesIterable()) {
            Map<String, List<SynHit>> tax2candidates = gm.getMentionMappingResult().tax2finalRankedCandidates;
            for (String tax : tax2candidates.keySet()) {
                tax2candidates.get(tax).sort(Comparator.comparingDouble(SynHit::getOverallScore).reversed());
            }
        }
    }

    private void selectGsMmr(GeneSet gs) {
        Optional<GeneMention> anyExactMatch;
        MentionMappingResult mmr = null;
        for (GeneMention gm : gs) {
            if (gm.getGeneDocument().getOverlappingAcronymLongforms(gm.getOffsets()).isEmpty()) continue;
            mmr = gm.getMentionMappingResult();
        }
        if (mmr == null && (anyExactMatch = gs.stream().filter(GeneMention::hasExactCandidateMatch).findAny()).isPresent()) {
            mmr = anyExactMatch.get().getMentionMappingResult();
        }
        if (mmr != null) {
            gs.setMentionMappingResult(mmr);
        }
    }

    private void resolveGeneSetContradictions(GeneDocument document) {
        Consumer<GeneSet> removeTopSynHit = gs -> {
            List<SynHit> synHits = gs.getMentionMappingResult().tax2finalRankedCandidates.get(gs.getTaxId());
            synHits.remove(0);
            if (synHits.isEmpty()) {
                synHits.add(MentionMappingResult.REJECTION);
                gs.getMentionMappingResult().setRejectReason(gs.getTaxId(), MentionMappingResult.RejectReason.NO_CANDIDATES_AFTER_GS_CONTRADICTION_RESOLUTION);
            }
        };
        Function<SynHit, Set> tokenize = sh -> Arrays.stream(sh.getMappedGeneName().getNormalizedText().split("\\s+")).collect(Collectors.toSet());
        Predicate<Set> allNumbers = s2 -> s2.stream().allMatch(i -> {
            try {
                Integer.valueOf(i);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        for (GeneSet gs1 : document.getGeneSets()) {
            for (GeneSet gs2 : document.getGeneSets()) {
                Sets.SetView differentTokens;
                if (gs1 == gs2) continue;
                SynHit best1 = gs1.getBestCandidate();
                SynHit best2 = gs2.getBestCandidate();
                if (best1 == null || best2 == null || best1.getId().equals("NoId") || best2.getId().equals("NoId") || !best1.getId().equals(best2.getId()) || (differentTokens = Sets.symmetricDifference(tokenize.apply(best1), tokenize.apply(best2))).size() != 2 || !allNumbers.test(differentTokens)) continue;
                if (best1.isExactMatch() && !best2.isExactMatch()) {
                    removeTopSynHit.accept(gs2);
                    continue;
                }
                if (best1.isExactMatch() || !best2.isExactMatch()) continue;
                removeTopSynHit.accept(gs1);
            }
        }
    }

    private void selectGenes(GeneDocument document, Stats stats, Parameters parameterMap) throws GeneMapperException {
        Parameters effectiveParameters = this.candidateSetter.getModelParameters() != null ? this.candidateSetter.getModelParameters() : parameterMap;
        document.clearSelectedGenes();
        document.selectGeneMentionsByTagger(GeneMention.GeneTagger.FLAIR_JPG_NOBC2TEST_NOTEST_COLLAPSED_VAR, GeneMention.GeneTagger.CONSISTENCY_TAGGER, GeneMention.GeneTagger.EXPANSION_TAGGER);
        document.setAcronymsAsGeneNameAlternatives();
        this.handleCompositeMentions(document, stats);
    }

    private void handleCompositeMentions(GeneDocument document, Stats stats) throws GeneMapperException {
        ArrayList<GeneMention> obsoleteMentions = new ArrayList<GeneMention>();
        ArrayList<GeneMention> newMentions = new ArrayList<GeneMention>();
        for (GeneMention predGm : document.getNonRejectedGenesIterable()) {
            List<GeneMention> identifiedGms;
            try {
                identifiedGms = this.geneCompositeNameResolver.resolve(predGm, new boolean[0]);
            }
            catch (Exception e) {
                log.debug("Error when trying to resolve composites in mention {}. Skipping.", (Object)predGm);
                identifiedGms = List.of(predGm);
            }
            if (identifiedGms.size() <= 1 && identifiedGms.get(0).equals(predGm)) continue;
            if (obsoleteMentions != null) {
                obsoleteMentions.add(predGm);
            }
            if (newMentions == null) continue;
            newMentions.addAll(identifiedGms);
        }
        obsoleteMentions.forEach(document::removeGene);
        newMentions.forEach(document::selectGene);
    }

    private void assignSpecies(GeneDocument document, Parameters parameters) throws SpeciesAssignmentException {
        if (parameters.getBoolean("use_gold_tax", false)) {
            for (GeneMention gm2 : document.getGenesIterable()) {
                if (gm2.hasGoldMentions()) {
                    gm2.setTaxonomyIds(gm2.getAllGoldTaxonomyIdsAsSet().stream().collect(Collectors.toList()));
                    continue;
                }
                gm2.setTaxonomyIds(List.of("9606"));
            }
            document.addState(GeneDocument.State.SPECIES_CANDIDATES_ASSIGNED);
            document.addState(GeneDocument.State.SPECIES_ASSIGNED_TO_GENES);
        }
        if (!document.hasState(GeneDocument.State.SPECIES_CANDIDATES_ASSIGNED) && !document.hasState(GeneDocument.State.SPECIES_ASSIGNED_TO_GENES)) {
            this.checkSpeciesAssigner();
            SpeciesHintSetter.setSpeciesMeshHeadings(document);
            this.assignmentFilter.filterSpeciesMentions(document);
            this.speciesAssigner.setSpeciesHints(parameters, document);
            this.assignmentFilter.filterAssignments(document);
            this.speciesAssigner.setSpeciesHints(parameters, document);
        }
        if (!document.hasState(GeneDocument.State.SPECIES_ASSIGNED_TO_GENES)) {
            this.checkSpeciesAssigner();
            document.getGenes().forEach(gm -> gm.setTaxonomyIds(Collections.emptyList()));
            this.speciesAssigner.assign(document, parameters);
        }
    }

    public void checkSpeciesAssigner() {
        if (this.speciesAssigner == null) {
            throw new IllegalStateException("There is no species assigner available, probably due to a failure to load the model. Check the previous log.");
        }
    }

    @Override
    public void shutdown() throws GeneMapperException {
        this.candidateSetter.shutdown();
        this.speciesAssigner.shutdown();
        this.geneCompositeNameResolver.shutdown();
    }

    @Override
    public void clear() {
        this.candidateSetter.clear();
    }

    @Override
    public MentionMappingResult map(GeneMention predictedMention) throws GeneMapperException {
        throw new NotImplementedException();
    }

    @Override
    public ContextRanker getContextualRanking() {
        return null;
    }

    @Override
    public CandidateRetrieval getCandidateRetrieval() {
        return this.candidateRetrieval;
    }

    @Override
    public TermNormalizer getTermNormalizer() {
        return this.normalizer;
    }

    public static enum NameLevelUnificationStrategy {
        JNET_FIRST,
        GAZETTEER_FIRST,
        LONGER_FIRST,
        JNET_ONLY;

    }
}

