/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.ioc;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import de.julielab.gene.candidateretrieval.ioc.IndexModule;
import de.julielab.geneexpbase.genemodel.GeneOrthologs;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.GeneMapper;
import de.julielab.genemapper.composites.FlairCompositeMentionTagger;
import de.julielab.genemapper.composites.GeneCompositeNameResolver;
import de.julielab.genemapper.disambig.ContextItemsIndex;
import de.julielab.genemapper.ioc.WikipediaModule;
import de.julielab.genemapper.mappingcores.DypsisCandidateRanker;
import de.julielab.genemapper.mappingcores.DypsisCandidateSetter;
import de.julielab.genemapper.mappingcores.MappingCore;
import de.julielab.genemapper.mappingcores.QuercusMappingCore;
import de.julielab.speciesassignment.ioc.SpeciesAssignmentModule;
import javax.inject.Named;
import javax.inject.Singleton;

public class GeneMappingModule
extends AbstractModule {
    private final de.julielab.geneexpbase.configuration.Configuration configuration;

    public GeneMappingModule(de.julielab.geneexpbase.configuration.Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(Configuration.class).toInstance(new Configuration(this.configuration));
        this.bind(GeneMapper.class);
        this.bind(MappingCore.class).to(QuercusMappingCore.class);
        this.bind(DypsisCandidateSetter.class);
        this.bind(DypsisCandidateRanker.class);
        this.bind(GeneOrthologs.class).in(Singleton.class);
        this.bind(FlairCompositeMentionTagger.class).in(Singleton.class);
        this.bind(GeneCompositeNameResolver.class).in(Singleton.class);
        this.bind(ContextItemsIndex.class).annotatedWith(Names.named(ContextItemsIndex.class.getSimpleName())).to(ContextItemsIndex.class).in(Singleton.class);
        this.install(new IndexModule(this.configuration));
        this.install(new WikipediaModule());
        this.install(new SpeciesAssignmentModule(this.configuration));
    }

    @Provides
    @Named(value="wikipedia_index")
    String provideWikipediaIndexPath(Configuration configuration) {
        String wikipediaIndex = configuration.getProperty("wikipedia_index");
        if (wikipediaIndex == null) {
            throw new IllegalArgumentException("Wikipedia index path is null. The path to the wikipedia index must be given in the configuration under the property \"wikipedia_index\".");
        }
        return wikipediaIndex;
    }
}

