/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.hpo;

import de.julielab.geneexpbase.hpo.HttpParamOptServer;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.hpo.CandidateRetrievalOptimizationRoute;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.LoggerFactory;

public class GnHpoServer
extends HttpParamOptServer {
    public static final File CONFIG_WITH_SA_SETTINGS = Path.of("nni", "gene_id_mapping.properties").toFile();
    public static final File CONFIG_WITH_SA_AND_LUCENE_SETTINGS = Path.of("nni", "gene_id_mapping_best_lucene_settings.properties").toFile();
    public static final File CONFIG_QUERCUS = Path.of("configurations", "gene_id_mapping_quercus_all_species.properties").toFile();

    public GnHpoServer(int port) throws IOException {
        super(LoggerFactory.getLogger(GnHpoServer.class), port);
        this.routes = List.of(new CandidateRetrievalOptimizationRoute(new Configuration(CONFIG_QUERCUS)));
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: " + GnHpoServer.class.getSimpleName() + " <http port>");
            System.exit(1);
        }
        int port = Integer.parseInt(args[0]);
        GnHpoServer server = new GnHpoServer(port);
        server.startServer();
    }
}

