/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.hpo;

import cc.mallet.types.Alphabet;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelAlphabet;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import de.julielab.evaluation.entities.EntityEvaluationResult;
import de.julielab.evaluation.entities.EntityEvaluationResults;
import de.julielab.evaluation.entities.EntityEvaluator;
import de.julielab.evaluation.entities.EvaluationData;
import de.julielab.evaluation.entities.EvaluationDataEntry;
import de.julielab.gene.candidateretrieval.CandidateRetrieval;
import de.julielab.gene.candidateretrieval.LuceneCandidateRetrieval;
import de.julielab.gene.candidateretrieval.scoring.MaxEntScorerFeaturePipe;
import de.julielab.geneexpbase.GeneIdCorrectness;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.DocumentMappingResult;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.MentionMappingResult;
import de.julielab.geneexpbase.hpo.HpoCorpusRegistry;
import de.julielab.geneexpbase.hpo.HpoInstance;
import de.julielab.geneexpbase.hpo.HpoRoute;
import de.julielab.geneexpbase.hpo.InspectionFilePrinter;
import de.julielab.geneexpbase.hpo.SplitType;
import de.julielab.geneexpbase.scoring.JaroWinklerScorer;
import de.julielab.geneexpbase.scoring.Scorer;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.GeneMapper;
import de.julielab.genemapper.evaluation.GeneIdCorrectnessRenderer;
import de.julielab.genemapper.evaluation.tools.Stats;
import de.julielab.genemapper.ioc.GeneMappingModule;
import de.julielab.genemapper.mappingcores.DypsisCandidateRanker;
import de.julielab.genemapper.mappingcores.DypsisMappingCore;
import de.julielab.genemapper.utils.GeneMapperException;
import de.julielab.genemapper.utils.GeneMapperRuntimeException;
import de.julielab.genemapper.utils.NDCG;
import de.julielab.java.utilities.Color;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.java.utilities.ProgressBar;
import de.julielab.speciesassignment.evaluation.SpeciesAssignmentCorrectnessRenderer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CandidateRetrievalOptimizationRoute
extends HpoRoute {
    public static final String GET_MENTION_SEARCH_SCORE = "get_mention_score_search";
    private static final Logger log = LoggerFactory.getLogger(CandidateRetrievalOptimizationRoute.class);
    private static final boolean PRINT_INSPECTION_FILES = true;
    private static final Set<String> documentsFilter = Set.of();
    private static final boolean PRINT_FULL_EVAL_METRICS = true;
    public static final boolean EVAL_ON_HUMAN_ONLY = false;
    private final EntityEvaluator entityEvaluator;
    private final Map<String, List<Pair<EvaluationData, EvaluationData>>> fullEvalData;
    private final Map<String, List<Pair<EvaluationData, EvaluationData>>> fullRejectionEvalData;
    private final InspectionFilePrinter inspectionFilePrinter;

    public CandidateRetrievalOptimizationRoute(Configuration configuration) {
        super(log, configuration);
        Function<GeneMention, Stream<String>> predictedIdFunction;
        Function<GeneDocument, Stream<String>> documentGoldIdFunction;
        Function<GeneMention, Stream<String>> geneMentionGoldIdFunction;
        Function<GeneMention, String> fpRenderer;
        Function<GeneMention, String> wrongIdRenderer;
        Function<GeneMention, String> correctIdRenderer;
        Properties properties = new Properties();
        properties.setProperty("comparison-type", EvaluationDataEntry.ComparisonType.OVERLAP.name());
        properties.setProperty("overlap-type", EvaluationDataEntry.OverlapType.CHARS.name());
        properties.setProperty("overlap-size", "1");
        this.entityEvaluator = new EntityEvaluator(properties);
        this.fullEvalData = new HashMap<String, List<Pair<EvaluationData, EvaluationData>>>();
        this.fullRejectionEvalData = new HashMap<String, List<Pair<EvaluationData, EvaluationData>>>();
        String idType = "gene";
        if (idType.equals("gene")) {
            correctIdRenderer = GeneIdCorrectnessRenderer::renderCorrectIdGeneMention;
            wrongIdRenderer = gm -> GeneIdCorrectnessRenderer.renderWrongIdGeneMention(gm, this.injector.getInstance(CandidateRetrieval.class), LuceneCandidateRetrieval.GENE_RECORDS_CNF);
            fpRenderer = GeneIdCorrectnessRenderer::renderNoCorrectCandidateIdGeneMention;
            geneMentionGoldIdFunction = gm -> gm.getIds().stream();
            documentGoldIdFunction = d -> d.getGoldIds().stream();
            predictedIdFunction = gm -> {
                if (gm.getMappedIds() == null || gm.getMappedIds().count() == 0L || gm.getMappedIds().anyMatch(Objects::isNull)) {
                    throw new IllegalArgumentException(gm.getMappedIds().collect(Collectors.toList()).toString());
                }
                return gm.getMappedIds();
            };
        } else if (idType.equals("taxonomy")) {
            correctIdRenderer = SpeciesAssignmentCorrectnessRenderer::renderCorrectTaxonomyGeneMention;
            wrongIdRenderer = gm -> SpeciesAssignmentCorrectnessRenderer.renderWrongTaxonomyGeneMention(gm, this.injector.getInstance(CandidateRetrieval.class), LuceneCandidateRetrieval.GENE_RECORDS_CNF);
            fpRenderer = SpeciesAssignmentCorrectnessRenderer::renderNoCorrectCandidateTaxonomyGeneMention;
            geneMentionGoldIdFunction = gm -> gm.getTaxonomyIds().stream();
            documentGoldIdFunction = d -> d.getGoldTaxonomyIds().stream();
            predictedIdFunction = gm -> {
                if (gm.getTaxonomyIds() == null || gm.getTaxonomyIds().isEmpty() || gm.getTaxonomyIds().stream().anyMatch(Objects::isNull)) {
                    throw new IllegalArgumentException(gm.getTaxonomyIds().toString());
                }
                return gm.getTaxonomyIds().stream();
            };
        } else {
            correctIdRenderer = GeneIdCorrectnessRenderer::renderCorrectRejection;
            wrongIdRenderer = GeneIdCorrectnessRenderer::renderMissedRejection;
            fpRenderer = GeneIdCorrectnessRenderer::renderIncorrectRejection;
            geneMentionGoldIdFunction = gm -> Stream.of(gm.hasGoldMentions() ? "0" : "1");
            documentGoldIdFunction = null;
            predictedIdFunction = gm -> Stream.of("0");
        }
        Function<GeneMention, GeneDocument.MentionCorrectness> correctnessFunction = gm -> GeneIdCorrectness.getIdCorrectnessLevel(gm, idType, this.injector.getInstance(CandidateRetrieval.class), LuceneCandidateRetrieval.GENE_RECORDS_CNF, new JaroWinklerScorer(), 0.9);
        this.inspectionFilePrinter = new InspectionFilePrinter(correctnessFunction, correctIdRenderer, wrongIdRenderer, fpRenderer, geneMentionGoldIdFunction, documentGoldIdFunction, predictedIdFunction);
    }

    @Override
    protected Injector createGuiceInjector(de.julielab.geneexpbase.configuration.Configuration configuration) {
        return Guice.createInjector(new GeneMappingModule(configuration));
    }

    @Override
    public String getRouteEndpoint() {
        return GET_MENTION_SEARCH_SCORE;
    }

    @Override
    public int getNumSplits() {
        return 1;
    }

    @Override
    public int getDevSamplingFrequency() {
        return 0;
    }

    @Override
    protected List<HpoInstance> getActiveCorpora() {
        return List.of(HpoCorpusRegistry.gnpBc2Train(), HpoCorpusRegistry.gnpNlmiat());
    }

    @Override
    protected String getTaskName() {
        return "lexrank";
    }

    @Override
    protected HpoRoute.Metric getDefaultMetric() {
        return HpoRoute.Metric.F;
    }

    @Override
    public String calculateScore(HpoInstance si, Parameters parameterMap, int seed, int cutoffTime, int resourceBudget, int maxResourceBudget, HpoRoute.Metric returnMetric, int runId) {
        GeneMapper geneMapper = this.injector.getInstance(GeneMapper.class);
        try {
            this.trainCandidateRankingModel(si, parameterMap, seed, false, resourceBudget, maxResourceBudget, geneMapper);
            boolean performMlTraining = !parameterMap.get(Configuration.dot("candidate_retrieval", "ml", "exactmatch", "algorithm")).equals("lucene") || !parameterMap.get(Configuration.dot("candidate_retrieval", "ml", "approxmatch", "algorithm")).equals("lucene");
            double result = this.evaluate(si, parameterMap, geneMapper, returnMetric, performMlTraining ? maxResourceBudget : resourceBudget, maxResourceBudget);
            if (si.getSplitType() == SplitType.TRAIN) {
                String algorithm = parameterMap.getString(Configuration.dot("candidate_retrieval", "ml", "approxmatch", "algorithm"));
                DecimalFormat df = new DecimalFormat("0.####");
                String modelBaseName = "lexrank-model-" + algorithm + "-" + runId + "-" + df.format(result);
                this.saveAndReevaluate(si, result, modelBaseName, false, geneMapper, returnMetric, parameterMap);
                log.info("Now re-training a model with train+dev data.");
                this.clearModelFromParameters(geneMapper, parameterMap);
                this.trainCandidateRankingModel(si, parameterMap, seed, true, Integer.MAX_VALUE, Integer.MAX_VALUE, geneMapper);
                double ndcgWithDev = this.evaluateParameters(si, parameterMap, geneMapper, this.getTrainingData(si, true, true), returnMetric);
                modelBaseName = "lexrank-final-model-withdev-" + algorithm + "-" + runId + "-" + df.format(ndcgWithDev);
                this.saveAndReevaluate(si, ndcgWithDev, modelBaseName, true, geneMapper, returnMetric, parameterMap);
            }
            this.printScorerTimes();
            String string = String.valueOf(result * -1.0);
            return string;
        }
        catch (Exception e) {
            log.error("Exception in score calculation", e);
            throw new GeneMapperRuntimeException(e);
        }
        finally {
            geneMapper.clearLexicalRankingModel();
        }
    }

    private void printScorerTimes() {
        if (Scorer.SCORING_TIME != null) {
            log.info("Feature creation times:");
            for (String scorerName : Scorer.SCORING_TIME.keySet()) {
                log.info("Scorer {} took {}s", (Object)scorerName, (Object)((double)Scorer.SCORING_TIME.get(scorerName).longValue() / Math.pow(10.0, 9.0)));
            }
            log.info("Token features took: {}s", (Object)((double)MaxEntScorerFeaturePipe.featureCreationTime / Math.pow(10.0, 9.0)));
            log.info("Lucene candidate retrieval took: {}s", (Object)((double)LuceneCandidateRetrieval.getTotalLuceneQueryTime().get() / Math.pow(10.0, 9.0)));
            log.info("Lucene field loading took: {}s", (Object)((double)LuceneCandidateRetrieval.getTotalGeneRecordFieldLoadingTime().get() / Math.pow(10.0, 9.0)));
            log.info("Lucene candidate cache hits: {}", (Object)LuceneCandidateRetrieval.getCacheHits().get());
            log.info("Lucene candidate cache misses: {}", (Object)LuceneCandidateRetrieval.getCacheMisses().get());
            LuceneCandidateRetrieval.getCacheHits().set(0L);
            LuceneCandidateRetrieval.getCacheMisses().set(0L);
        }
    }

    private void clearModelFromParameters(GeneMapper geneMapper, Parameters parameterMap) {
        parameterMap.remove(Configuration.dot("candidate_retrieval", "classifier"));
        parameterMap.remove(Configuration.dot("candidate_retrieval", "ranker"));
        parameterMap.remove(Configuration.dot("candidate_retrieval", "data_alphabet"));
        parameterMap.remove(Configuration.dot("candidate_retrieval", "target_alphabet"));
        parameterMap.remove(Configuration.dot("candidate_retrieval", "min_result_score"));
        parameterMap.remove(Configuration.dot("candidate_retrieval", "max_result_score"));
        parameterMap.remove(Configuration.dot("candidate_retrieval", "min_family_match_score"));
        parameterMap.remove(Configuration.dot("candidate_retrieval", "max_family_match_score"));
        geneMapper.clearLexicalRankingModel();
    }

    private void saveAndReevaluate(HpoInstance si, double originalResult, String modelBaseName, boolean trainWithDev, GeneMapper geneMapper, HpoRoute.Metric returnMetric, Parameters parameterMap) {
        File modelPath = new File(modelBaseName + ".mod");
        ((DypsisMappingCore)geneMapper.getMappingCore()).saveCandidateSetter(modelPath, parameterMap);
        log.info("Loading saved model again and evaluating it for score comparison.");
        List<GeneDocument> documents = trainWithDev ? this.getTrainingData(si, true, true) : this.getDocuments4Instance(si);
        this.evalWithSavedModel(si, modelPath, geneMapper, parameterMap, documents, originalResult, returnMetric);
    }

    private void evalWithSavedModel(HpoInstance si, File modelPath, GeneMapper geneMapper, Parameters parameterMap, List<GeneDocument> documentsForEvaluation, double originalNdcg, HpoRoute.Metric returnMetric) {
        try {
            ((DypsisMappingCore)geneMapper.getMappingCore()).loadCandidateSetter(modelPath);
            double newNdcg = this.evaluateParameters(si, parameterMap, geneMapper, documentsForEvaluation, returnMetric);
            log.info("Obtained nDCG for saved and re-loaded model of {}", (Object)newNdcg);
            if (Math.abs(newNdcg - newNdcg) > 1.0E-6) {
                log.warn("The loaded model exhibits different performance than the before saving. Original nDCG: {}, nDCG after model loading from {}: {}", originalNdcg, modelPath, newNdcg);
            }
        }
        catch (GeneMapperException | IOException | ClassNotFoundException e) {
            log.error("Could not reload the saved model and do candidate ranking with it.");
            throw new GeneMapperRuntimeException(e);
        }
    }

    private double evaluate(HpoInstance si, Parameters parameterMap, GeneMapper geneMapper, HpoRoute.Metric returnMetric, int resourceBudget, int maxResourceBudget) throws GeneMapperException {
        List<GeneDocument> testPartition = this.getDocuments4Budget4Instance(si, resourceBudget, maxResourceBudget);
        log.info("Evaluating instance {}", (Object)si);
        double result = this.evaluateParameters(si, parameterMap, geneMapper, testPartition, returnMetric);
        log.info("Got {} {} for instance {}.", new Object[]{returnMetric, result, si});
        return result;
    }

    private double evaluateParameters(HpoInstance si, Parameters parameterMap, GeneMapper geneMapper, List<GeneDocument> testPartition, HpoRoute.Metric returnMetric) throws GeneMapperException {
        double metricResult;
        DoubleStream.Builder ndcgValueStreamBuilder = DoubleStream.builder();
        double sumNdcg = 0.0;
        Stats stats = new Stats();
        int numGold = 0;
        int numcandidates = 0;
        int numLists = 0;
        int numPred = 0;
        int numPredExact = 0;
        int numPredApprox = 0;
        int numPredGmWithGoldIdExact = 0;
        int numPredGmWithGoldIdAt10Exact = 0;
        int numPredGmWithGoldMentionExact = 0;
        boolean numPredGmWithGoldMentionWrongAt1Exact = false;
        int numCorrectAt1Exact = 0;
        int numPredGmWithGoldIdApprox = 0;
        int numPredGmWithGoldIdAt10Approx = 0;
        int numPredGmWithGoldMentionApprox = 0;
        int numCorrectAt1Approx = 0;
        ArrayList rejected = new ArrayList();
        EvaluationData goldData = new EvaluationData();
        EvaluationData predData = new EvaluationData();
        EvaluationData goldData2 = new EvaluationData();
        EvaluationData predData2 = new EvaluationData();
        EvaluationData goldFamilyData = new EvaluationData();
        EvaluationData predFamilyData = new EvaluationData();
        EvaluationData goldNerData = new EvaluationData();
        EvaluationData predNerData = new EvaluationData();
        Function<MentionMappingResult, Map> getResultCandidates = mmr -> mmr.tax2lexicallyRerankedCandidates;
        ArrayList<GeneDocument> copies = new ArrayList<GeneDocument>(testPartition.size());
        log.debug("Evaluating on {} test documents", (Object)testPartition.size());
        ProgressBar progressBar = new ProgressBar(testPartition.size(), 0L, 80, true);
        for (GeneDocument testDoc : testPartition) {
            if (!documentsFilter.isEmpty() && !documentsFilter.contains(testDoc.getId())) continue;
            GeneDocument copy = new GeneDocument(testDoc);
            copies.add(copy);
            DocumentMappingResult result = geneMapper.map(copy, parameterMap, stats);
            result.mentionResults.forEach(mmr -> {
                mmr.tax2finalRankedCandidates = (Map)getResultCandidates.apply((MentionMappingResult)mmr);
            });
            for (MentionMappingResult mmr2 : result.mentionResults) {
                ++numPred;
                Map rankedCandidates = getResultCandidates.apply(mmr2);
                for (String tax : rankedCandidates.keySet()) {
                    ++numLists;
                    numcandidates += ((List)rankedCandidates.get(tax)).size();
                    double ndcg = NDCG.ndcg((Collection)rankedCandidates.get(tax), 10);
                    assert (!Double.isNaN(ndcg));
                    ndcgValueStreamBuilder.accept(ndcg);
                    sumNdcg += ndcg;
                }
            }
            if (copy.isGoldHasOffsets()) {
                copy.getGoldGenes().values().stream().flatMap(Collection::stream).filter(gm -> true).flatMap(gm -> gm.getIds().stream().map(id -> {
                    EvaluationDataEntry goldEntry = new EvaluationDataEntry(gm.getDocId(), (String)id, gm.getBegin(), gm.getEnd(), gm.getText(), gm.getTagger().name(), "Gene");
                    goldEntry.setReferenceObject(gm);
                    return goldEntry;
                })).forEach(goldData::add);
            } else {
                copy.getGoldIds().stream().map(id -> new EvaluationDataEntry(copy.getId(), (String)id, -1, -1, "", "Gold", "Gene")).forEach(goldData::add);
            }
            copy.getGenes().filter(Predicate.not(GeneMention::isRejected)).flatMap(gm -> gm.getMentionMappingResult().tax2finalRankedCandidates.values().stream().map(l -> (SynHit)l.get(0)).map(sh -> {
                EvaluationDataEntry e = new EvaluationDataEntry(gm.getDocId(), sh.getId() != null ? sh.getId() : "0", gm.getBegin(), gm.getEnd(), gm.getText(), gm.getTagger().name(), "Gene");
                e.setReferenceObject(gm);
                return e;
            })).forEach(predData::add);
            copy.getGoldGenes().values().stream().flatMap(Collection::stream).map(gm -> {
                EvaluationDataEntry goldEntry = new EvaluationDataEntry(gm.getDocId(), "0", gm.getBegin(), gm.getEnd(), gm.getText(), gm.getTagger().name(), "Gene");
                goldEntry.setReferenceObject(gm);
                return goldEntry;
            }).forEach(goldNerData::add);
            copy.getGenes().filter(Predicate.not(GeneMention::isRejected)).map(gm -> {
                EvaluationDataEntry e = new EvaluationDataEntry(gm.getDocId(), "0", gm.getBegin(), gm.getEnd(), gm.getText(), gm.getTagger().name(), "Gene");
                e.setReferenceObject(gm);
                return e;
            }).forEach(predNerData::add);
            copy.getGenes().filter(Predicate.not(GeneMention::hasGoldMentions)).map(gm -> {
                EvaluationDataEntry e = new EvaluationDataEntry(gm.getDocId(), "0", gm.getBegin(), gm.getEnd());
                e.setEntityString(gm.getText());
                e.setEntityType(gm.hasExactCandidateMatch() ? "exactmatch" : "approxmatch");
                return e;
            }).forEach(goldFamilyData::add);
            copy.getGenes().filter(GeneMention::isRejected).map(gm -> {
                EvaluationDataEntry e = new EvaluationDataEntry(gm.getDocId(), "0", gm.getBegin(), gm.getEnd());
                e.setEntityString(gm.getText());
                e.setEntityType(gm.hasExactCandidateMatch() ? "exactmatch" : "approxmatch");
                return e;
            }).forEach(predFamilyData::add);
            numGold = (int)((long)numGold + copy.getGoldGenes().values().stream().flatMap(Collection::stream).count());
            copy.getGenes().filter(GeneMention::isRejected).forEach(rejected::add);
            Iterator goldGenes = copy.getGoldGenes().values().stream().flatMap(Collection::stream).iterator();
            while (goldGenes.hasNext()) {
                Set candidateIdsAt10;
                boolean predHasGoldCandidateAt10;
                Set candidateIds;
                boolean predHasGoldCandidate;
                GeneMention goldGene = (GeneMention)goldGenes.next();
                List predGenes = copy.getOverlappingGenes(goldGene.getOffsets()).filter(Predicate.not(GeneMention::isRejected)).collect(Collectors.toList());
                boolean predGenesExact = predGenes.stream().anyMatch(GeneMention::hasExactCandidateMatch);
                if (!predGenes.isEmpty()) {
                    if (predGenesExact) {
                        ++numPredGmWithGoldMentionExact;
                    } else {
                        ++numPredGmWithGoldMentionApprox;
                    }
                }
                boolean bl = predHasGoldCandidate = !Sets.intersection(candidateIds = predGenes.stream().filter(Predicate.not(GeneMention::isRejected)).flatMap(gm -> ((Map)getResultCandidates.apply(gm.getMentionMappingResult())).values().stream().flatMap(Collection::stream)).map(SynHit::getId).collect(Collectors.toSet()), new HashSet<String>(goldGene.getIds())).isEmpty();
                if (predHasGoldCandidate) {
                    if (predGenesExact) {
                        ++numPredGmWithGoldIdExact;
                    } else {
                        ++numPredGmWithGoldIdApprox;
                    }
                }
                if (!(predHasGoldCandidateAt10 = !Sets.intersection(candidateIdsAt10 = predGenes.stream().filter(Predicate.not(GeneMention::isRejected)).flatMap(gm -> ((Map)getResultCandidates.apply(gm.getMentionMappingResult())).values().stream().map(l -> l.subList(0, Math.min(l.size(), 10))).flatMap(Collection::stream)).map(SynHit::getId).collect(Collectors.toSet()), new HashSet<String>(goldGene.getIds())).isEmpty())) continue;
                if (predGenesExact) {
                    ++numPredGmWithGoldIdAt10Exact;
                    continue;
                }
                ++numPredGmWithGoldIdAt10Approx;
            }
            ArrayList correct = new ArrayList();
            HashSet alreadySeen = new HashSet();
            for (GeneMention predGm : copy.getNonRejectedGenesIterable()) {
                if (predGm.hasExactCandidateMatch()) {
                    ++numPredExact;
                    continue;
                }
                ++numPredApprox;
            }
            correct.clear();
            progressBar.incrementDone(true);
        }
        if (goldData.isMentionData()) {
            goldData.stream().filter(e -> ((GeneMention)e.getReferenceObject()).hasExactCandidateMatch() || ((GeneMention)e.getReferenceObject()).getGeneDocument().getOverlappingGenes(((GeneMention)e.getReferenceObject()).getOffsets()).anyMatch(GeneMention::hasExactCandidateMatch)).map(EvaluationDataEntry::copy).peek(e -> e.setEntityType("exactmatch")).forEach(goldData2::add);
            goldData.stream().filter(e -> !((GeneMention)e.getReferenceObject()).hasExactCandidateMatch() || !((GeneMention)e.getReferenceObject()).getGeneDocument().getOverlappingGenes(((GeneMention)e.getReferenceObject()).getOffsets()).anyMatch(GeneMention::hasExactCandidateMatch)).map(EvaluationDataEntry::copy).peek(e -> e.setEntityType("approxmatch")).forEach(goldData2::add);
            predData.stream().filter(e -> ((GeneMention)e.getReferenceObject()).hasExactCandidateMatch()).map(EvaluationDataEntry::copy).peek(e -> e.setEntityType("exactmatch")).forEach(predData2::add);
            predData.stream().filter(e -> ((GeneMention)e.getReferenceObject()).hasOnlyApproximateCandidateMatches()).map(EvaluationDataEntry::copy).peek(e -> e.setEntityType("approxmatch")).forEach(predData2::add);
        }
        String fullDataKey = si.getCorpus() + si.getSubcorpus() + si.getInstanceInfo() + parameterMap.getKeysGivenByHpo().stream().map(k -> k + parameterMap.get(k)).collect(Collectors.joining());
        this.fullEvalData.compute(fullDataKey, (k, v) -> v != null ? v : new ArrayList()).add(new ImmutablePair<EvaluationData, EvaluationData>(goldData, predData));
        this.fullRejectionEvalData.compute(fullDataKey, (k, v) -> v != null ? v : new ArrayList()).add(new ImmutablePair<EvaluationData, EvaluationData>(goldFamilyData, predFamilyData));
        EntityEvaluationResults evalResult = this.entityEvaluator.evaluate(goldData, predData);
        EntityEvaluationResults evalResult2 = this.entityEvaluator.evaluate(goldData2, predData2);
        EntityEvaluationResults familyEvaluationResults = this.entityEvaluator.evaluate(goldFamilyData, predFamilyData);
        EntityEvaluationResults nerResults = this.entityEvaluator.evaluate(goldNerData, predNerData);
        EntityEvaluationResult resultToInspect = evalResult.getOverallResult();
        this.inspectionFilePrinter.printInspectionFile(resultToInspect, "gene", returnMetric, si, copies, geneMapper.getMappingCore().getCandidateRetrieval(), LuceneCandidateRetrieval.GENE_RECORDS_CNF);
        EntityEvaluationResult result = evalResult.getSingle();
        numCorrectAt1Exact = (int)result.getEntrySetsByDocumentMentionWise().values().stream().flatMap(e -> e.tpSet.stream()).map(x -> x.getReferenceObject()).map(GeneMention.class::cast).filter(GeneMention::hasExactCandidateMatch).count();
        numCorrectAt1Approx = (int)result.getEntrySetsByDocumentMentionWise().values().stream().flatMap(e -> e.tpSet.stream()).map(x -> x.getReferenceObject()).map(GeneMention.class::cast).filter(Predicate.not(GeneMention::hasExactCandidateMatch)).count();
        double maxReachableRecall = (double)(numPredGmWithGoldIdExact + numPredGmWithGoldIdApprox) / (double)numGold;
        double maxReachableRecallAt10 = (double)(numPredGmWithGoldIdAt10Exact + numPredGmWithGoldIdAt10Approx) / (double)numGold;
        double pAt1 = result.getMicroPrecisionMentionWise();
        double maxReachableRecallExact = (double)numPredGmWithGoldIdExact / (double)numPredGmWithGoldMentionExact;
        double maxReachableRecallAt10Exact = (double)numPredGmWithGoldIdAt10Exact / (double)numGold;
        double pAt1Exact = (double)numCorrectAt1Exact / (double)numPredGmWithGoldMentionExact;
        double recallExact = (double)numCorrectAt1Exact / (double)numGold;
        double maxReachableRecallAt10Approx = (double)numPredGmWithGoldIdAt10Approx / (double)numGold;
        double pAt1Approx = (double)numCorrectAt1Approx / (double)numPredGmWithGoldMentionApprox;
        double recallApprox = (double)numCorrectAt1Approx / (double)numGold;
        double maxReachableRecallApprox = (double)numPredGmWithGoldIdApprox / (double)numPredGmWithGoldMentionApprox;
        double avgNdcg = sumNdcg / (double)numLists;
        double fscore = result.getMicroFMeasureMentionWise();
        double precision = result.getMicroPrecisionMentionWise();
        double recall = result.getMicroRecallMentionWise();
        double fscoreDocwise = result.getMicroFMeasureDocWise();
        double precisionDocwise = result.getMicroPrecisionDocWise();
        double recallDocwise = result.getMicroRecallDocWise();
        EntityEvaluationResult familyEvalOverallResult = familyEvaluationResults.getOverallResult();
        double familyTp = familyEvalOverallResult != null ? (double)familyEvalOverallResult.getSumTpMentionWise() : 0.0;
        double familyFp = familyEvalOverallResult != null ? (double)familyEvalOverallResult.getSumFpMentionWise() : 0.0;
        double familyFn = familyEvalOverallResult != null ? (double)familyEvalOverallResult.getSumFnMentionWise() : 0.0;
        EntityEvaluationResult familyEvalResultExactMatches = (EntityEvaluationResult)familyEvaluationResults.get("exactmatch");
        EntityEvaluationResult familyEvalResultApproxMatches = (EntityEvaluationResult)familyEvaluationResults.get("approxmatch");
        double familyTpExact = familyEvalResultExactMatches != null ? (double)familyEvalResultExactMatches.getSumTpMentionWise() : 0.0;
        double familyFpExact = familyEvalResultExactMatches != null ? (double)familyEvalResultExactMatches.getSumFpMentionWise() : 0.0;
        double familyFnExact = familyEvalResultExactMatches != null ? (double)familyEvalResultExactMatches.getSumFnMentionWise() : 0.0;
        double familyTpApprox = familyEvalResultApproxMatches != null ? (double)familyEvalResultApproxMatches.getSumTpMentionWise() : 0.0;
        double familyFpApprox = familyEvalResultApproxMatches != null ? (double)familyEvalResultApproxMatches.getSumFpMentionWise() : 0.0;
        double familyFnApprox = familyEvalResultApproxMatches != null ? (double)familyEvalResultApproxMatches.getSumFnMentionWise() : 0.0;
        double familyR = familyEvaluationResults.getMicroStatsMentionWise().getRecall();
        double familyP = familyEvaluationResults.getMicroStatsMentionWise().getPrecision();
        double familyF = familyEvaluationResults.getMicroStatsMentionWise().getF();
        double familyRExact = familyEvalResultExactMatches != null ? familyEvalResultExactMatches.getMicroRecallMentionWise() : 0.0;
        double familyPExact = familyEvalResultExactMatches != null ? familyEvalResultExactMatches.getMicroPrecisionMentionWise() : 0.0;
        double familyFExact = familyEvalResultExactMatches != null ? familyEvalResultExactMatches.getMicroFMeasureMentionWise() : 0.0;
        double familyRApprox = familyEvalResultApproxMatches != null ? familyEvalResultApproxMatches.getMicroRecallMentionWise() : 0.0;
        double familyPApprox = familyEvalResultApproxMatches != null ? familyEvalResultApproxMatches.getMicroPrecisionMentionWise() : 0.0;
        double familyFApprox = familyEvalResultApproxMatches != null ? familyEvalResultApproxMatches.getMicroFMeasureMentionWise() : 0.0;
        OptionalDouble scoreOpt = ndcgValueStreamBuilder.build().average();
        switch (returnMetric) {
            case MAX_RECALL: {
                metricResult = maxReachableRecall;
                break;
            }
            case NDCG: {
                metricResult = scoreOpt.isPresent() && !Double.isNaN(scoreOpt.getAsDouble()) ? scoreOpt.getAsDouble() : 0.0;
                break;
            }
            case MAX_REC_10: {
                metricResult = maxReachableRecallAt10;
                break;
            }
            case P1: {
                metricResult = pAt1;
                break;
            }
            case RECALL: {
                metricResult = recall;
                break;
            }
            case PRECISION: {
                metricResult = precision;
                break;
            }
            case F: {
                metricResult = fscore;
                break;
            }
            case RECALL_REJECTION: {
                metricResult = familyR;
                break;
            }
            case PRECISION_REJECTION: {
                metricResult = familyP;
                break;
            }
            case F_REJECTION: {
                metricResult = familyF;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported metric " + returnMetric);
            }
        }
        if (log.isDebugEnabled()) {
            log.info("NER metrics for {}: [R / P / F]: {}{}{} / {}{}{} / {}{}{}", new Object[]{si, Color.MAGENTA, nerResults.getOverallResult().getMicroRecallMentionWise(), Color.RESET, Color.BRIGHT_BLUE, nerResults.getOverallResult().getMicroPrecisionMentionWise(), Color.RESET, Color.YELLOW, nerResults.getOverallResult().getMicroFMeasureMentionWise(), Color.RESET});
            log.info("Mapped {} predicted gene mentions. After rejections, there were {} exact matches and {} approximate matches.", numPred, numPredExact, numPredApprox);
            log.info("ID Mapping Metrics for {}: [R / P / F]: {}{}{} / {}{}{} / {}{}{}; TPs: {} FPs: {} FNs: {}", new Object[]{si, Color.MAGENTA, recall, Color.RESET, Color.BRIGHT_BLUE, precision, Color.RESET, Color.YELLOW, fscore, Color.RESET, result.getSumTpMentionWise(), result.getSumFpMentionWise(), result.getSumFnMentionWise()});
            log.info("ID Mapping Metrics for {} on document-level: [R / P / F]: {}{}{} / {}{}{} / {}{}{}; TPs: {} FPs: {} FNs: {}", new Object[]{si, Color.MAGENTA, recallDocwise, Color.RESET, Color.BRIGHT_BLUE, precisionDocwise, Color.RESET, Color.YELLOW, fscoreDocwise, Color.RESET, result.getSumTpDocWise(), result.getSumFpDocWise(), result.getSumFnDocWise()});
            if (goldData.isMentionData()) {
                log.info("ID Mapping Metrics for {}, exact matches: [R / P / F]: {}{}{} / {}{}{} / {}{}{}; TPs: {} FPs: {} FNs: {}", new Object[]{si, Color.MAGENTA, ((EntityEvaluationResult)evalResult2.get("exactmatch")).getMicroRecallMentionWise(), Color.RESET, Color.BRIGHT_BLUE, ((EntityEvaluationResult)evalResult2.get("exactmatch")).getMicroPrecisionMentionWise(), Color.RESET, Color.YELLOW, ((EntityEvaluationResult)evalResult2.get("exactmatch")).getMicroFMeasureMentionWise(), Color.RESET, ((EntityEvaluationResult)evalResult2.get("exactmatch")).getSumTpMentionWise(), ((EntityEvaluationResult)evalResult2.get("exactmatch")).getSumFpMentionWise(), ((EntityEvaluationResult)evalResult2.get("exactmatch")).getSumFnMentionWise()});
                log.info("ID Mapping Metrics for {}, approx matches: [R / P / F]: {}{}{} / {}{}{} / {}{}{}; TPs: {} FPs: {} FNs: {}", new Object[]{si, Color.MAGENTA, ((EntityEvaluationResult)evalResult2.get("approxmatch")).getMicroRecallMentionWise(), Color.RESET, Color.BRIGHT_BLUE, ((EntityEvaluationResult)evalResult2.get("approxmatch")).getMicroPrecisionMentionWise(), Color.RESET, Color.YELLOW, ((EntityEvaluationResult)evalResult2.get("approxmatch")).getMicroFMeasureMentionWise(), Color.RESET, ((EntityEvaluationResult)evalResult2.get("approxmatch")).getSumTpMentionWise(), ((EntityEvaluationResult)evalResult2.get("approxmatch")).getSumFpMentionWise(), ((EntityEvaluationResult)evalResult2.get("approxmatch")).getSumFnMentionWise()});
            }
            if (evalResult2.get("exactmatch") != null) {
                log.info("ID Mapping Metrics for {}, exact matches, document-level: [R / P / F]: {}{}{} / {}{}{} / {}{}{}; TPs: {} FPs: {} FNs: {}", new Object[]{si, Color.MAGENTA, ((EntityEvaluationResult)evalResult2.get("exactmatch")).getMicroRecallDocWise(), Color.RESET, Color.BRIGHT_BLUE, ((EntityEvaluationResult)evalResult2.get("exactmatch")).getMicroPrecisionDocWise(), Color.RESET, Color.YELLOW, ((EntityEvaluationResult)evalResult2.get("exactmatch")).getMicroFMeasureDocWise(), Color.RESET, ((EntityEvaluationResult)evalResult2.get("exactmatch")).getSumTpDocWise(), ((EntityEvaluationResult)evalResult2.get("exactmatch")).getSumFpDocWise(), ((EntityEvaluationResult)evalResult2.get("exactmatch")).getSumFnDocWise()});
            }
            if (evalResult2.get("approxmatch") != null) {
                log.info("ID Mapping Metrics for {}, approx matches, document-level: [R / P / F]: {}{}{} / {}{}{} / {}{}{}; TPs: {} FPs: {} FNs: {}", new Object[]{si, Color.MAGENTA, ((EntityEvaluationResult)evalResult2.get("approxmatch")).getMicroRecallDocWise(), Color.RESET, Color.BRIGHT_BLUE, ((EntityEvaluationResult)evalResult2.get("approxmatch")).getMicroPrecisionDocWise(), Color.RESET, Color.YELLOW, ((EntityEvaluationResult)evalResult2.get("approxmatch")).getMicroFMeasureDocWise(), Color.RESET, ((EntityEvaluationResult)evalResult2.get("approxmatch")).getSumTpDocWise(), ((EntityEvaluationResult)evalResult2.get("approxmatch")).getSumFpDocWise(), ((EntityEvaluationResult)evalResult2.get("approxmatch")).getSumFnDocWise()});
            }
            log.info("Rejection metrics for {}, overall: [R / P / F]: {}{}{} / {}{}{} / {}{}{}; TPs: {} FPs: {} FNs: {}", new Object[]{si, Color.MAGENTA, familyR, Color.RESET, Color.BRIGHT_BLUE, familyP, Color.RESET, Color.YELLOW, familyF, Color.RESET, familyEvalOverallResult.getSumTpMentionWise(), familyEvalOverallResult.getSumFpMentionWise(), familyEvalOverallResult.getSumFnMentionWise()});
            if (familyEvalResultExactMatches != null) {
                log.info("Rejection metrics for {}, exact: [R / P / F]: {}{}{} / {}{}{} / {}{}{}; TPs: {} FPs: {} FNs: {}", new Object[]{si, Color.MAGENTA, familyRExact, Color.RESET, Color.BRIGHT_BLUE, familyPExact, Color.RESET, Color.YELLOW, familyFExact, Color.RESET, familyEvalResultExactMatches.getSumTpMentionWise(), familyEvalResultExactMatches.getSumFpMentionWise(), familyEvalResultExactMatches.getSumFnMentionWise()});
            }
            if (familyEvalResultApproxMatches != null) {
                log.info("Rejection metrics for {}, approx: [R / P / F]: {}{}{} / {}{}{} / {}{}{}; TPs: {} FPs: {} FNs: {}", new Object[]{si, Color.MAGENTA, familyRApprox, Color.RESET, Color.BRIGHT_BLUE, familyPApprox, Color.RESET, Color.YELLOW, familyFApprox, Color.RESET, familyEvalResultApproxMatches.getSumTpMentionWise(), familyEvalResultApproxMatches.getSumFpMentionWise(), familyEvalResultApproxMatches.getSumFnMentionWise()});
            }
            log.info("Max reachable recall (number genes with correct ID in candidate list relative to number of TP mentions): {}/{}={}", numPredGmWithGoldIdExact + numPredGmWithGoldIdApprox, numPredGmWithGoldMentionExact + numPredGmWithGoldMentionApprox, maxReachableRecall);
            log.info("Max reachable recall (number of exact matches with correct candidate relative to all TP exact matches), exact matches: {}/{}={}", numPredGmWithGoldIdExact, numPredGmWithGoldMentionExact, maxReachableRecallExact);
            log.info("Max reachable recall(number of approximate matches with correct candidate relative to all TP approximate matches), approx matches: {}/{}={}", numPredGmWithGoldIdApprox, numPredGmWithGoldMentionApprox, maxReachableRecallApprox);
            log.debug("Got {} scored candidates ({}: {}), num lists: {} for {}", new Object[]{numcandidates, returnMetric, metricResult, numLists, si});
            if (returnMetric != HpoRoute.Metric.NDCG) {
                log.debug("Got nDCG of {} for {}", (Object)avgNdcg, (Object)si);
            }
        }
        if (this.fullEvalData.get(fullDataKey).size() == this.getNumSplits()) {
            List<Pair<EvaluationData, EvaluationData>> evalData = this.fullEvalData.get(fullDataKey);
            EvaluationData completeGoldEvalData = new EvaluationData();
            EvaluationData completePredEvalData = new EvaluationData();
            for (Pair<EvaluationData, EvaluationData> pair : evalData) {
                completeGoldEvalData.addAll(pair.getLeft());
                completePredEvalData.addAll(pair.getRight());
            }
            EntityEvaluationResult completeEvalResult = this.entityEvaluator.evaluate(completeGoldEvalData, completePredEvalData).getSingle();
            String dataName = si.getCorpus() + "-" + si.getSubcorpus();
            log.info("Complete ID Mapping Metrics for {}: [R / P / F]: {}{}{} / {}{}{} / {}{}{}", new Object[]{dataName, Color.MAGENTA, completeEvalResult.getMicroRecallMentionWise(), Color.RESET, Color.BRIGHT_BLUE, completeEvalResult.getMicroPrecisionMentionWise(), Color.RESET, Color.YELLOW, completeEvalResult.getMicroFMeasureMentionWise(), Color.RESET});
            List<Pair<EvaluationData, EvaluationData>> rejectionEvalData = this.fullRejectionEvalData.get(fullDataKey);
            EvaluationData completeRejectionGoldEvalData = new EvaluationData();
            EvaluationData completeRejectionPredEvalData = new EvaluationData();
            for (Pair<EvaluationData, EvaluationData> pair : rejectionEvalData) {
                completeRejectionGoldEvalData.addAll(pair.getLeft());
                completeRejectionPredEvalData.addAll(pair.getRight());
            }
            EntityEvaluationResults completeRejectionEvalResult = this.entityEvaluator.evaluate(completeRejectionGoldEvalData, completeRejectionPredEvalData);
            EntityEvaluationResult completeExactRejectionEvalResult = (EntityEvaluationResult)completeRejectionEvalResult.get("exactmatch");
            EntityEvaluationResult completeApproxRejectionEvalResult = (EntityEvaluationResult)completeRejectionEvalResult.get("approxmatch");
            log.info("Complete Rejection metrics for {}, overall: [R / P / F]: {}{}{} / {}{}{} / {}{}{}", new Object[]{dataName, Color.MAGENTA, completeRejectionEvalResult.getMicroStatsMentionWise().getRecall(), Color.RESET, Color.BRIGHT_BLUE, completeRejectionEvalResult.getMicroStatsMentionWise().getPrecision(), Color.RESET, Color.YELLOW, completeRejectionEvalResult.getMicroStatsMentionWise().getF(), Color.RESET});
            if (completeExactRejectionEvalResult != null) {
                log.info("Complete Rejection metrics for {}, exact: [R / P / F]: {}{}{} / {}{}{} / {}{}{}", new Object[]{dataName, Color.MAGENTA, completeExactRejectionEvalResult.getMicroRecallMentionWise(), Color.RESET, Color.BRIGHT_BLUE, completeExactRejectionEvalResult.getMicroPrecisionMentionWise(), Color.RESET, Color.YELLOW, completeExactRejectionEvalResult.getMicroFMeasureMentionWise(), Color.RESET});
            }
            if (completeApproxRejectionEvalResult != null) {
                log.info("Complete Rejection metrics for {}, approx: [R / P / F]: {}{}{} / {}{}{} / {}{}{}", new Object[]{dataName, Color.MAGENTA, completeApproxRejectionEvalResult.getMicroRecallMentionWise(), Color.RESET, Color.BRIGHT_BLUE, completeApproxRejectionEvalResult.getMicroPrecisionMentionWise(), Color.RESET, Color.YELLOW, completeApproxRejectionEvalResult.getMicroFMeasureMentionWise(), Color.RESET});
            }
            System.out.println("Avg Diff correct: " + DypsisCandidateRanker.avgDiffCorrect / (double)DypsisCandidateRanker.correct);
            System.out.println("Avg ratio correct: " + DypsisCandidateRanker.avgRatioCorrect / (double)DypsisCandidateRanker.correct);
            System.out.println("Avg Diff  wrong: " + DypsisCandidateRanker.avgDiffWrong / DypsisCandidateRanker.wrong);
            System.out.println("Avg ratio wrong: " + DypsisCandidateRanker.avgRatioWrong / DypsisCandidateRanker.wrong);
        }
        this.writeEvaluationGeneLists(goldData, predData, si);
        return metricResult;
    }

    private void writeEvaluationGeneLists(EvaluationData goldData, EvaluationData predData, HpoInstance si) {
        try (BufferedWriter bwGold = FileUtilities.getWriterToFile(new File(si.toString() + "-gold.genelist"));
             BufferedWriter bw = FileUtilities.getWriterToFile(new File(si + ".genelist"));){
            for (EvaluationDataEntry e : goldData) {
                bwGold.write(e.getDocId() + "\t" + e.getEntityId() + "\t" + e.getBegin() + "\t" + e.getEnd() + "\t" + e.getEntityString());
                bwGold.newLine();
            }
            for (EvaluationDataEntry e : predData) {
                bw.write(e.getDocId() + "\t" + e.getEntityId() + "\t" + e.getBegin() + "\t" + e.getEnd() + "\t" + e.getEntityString());
                bw.newLine();
            }
        }
        catch (IOException e) {
            log.error("Could not write the genelist for the current hpo-instance {}", (Object)si, (Object)e);
        }
    }

    private void trainCandidateRankingModel(HpoInstance si, Parameters parameterMap, int seed, boolean trainWithDev, int resourceBudget, int maxResourceBudget, GeneMapper geneMapper) throws GeneMapperException {
        String prefix = "candidate_retrieval";
        Set<String> nonFeatureApproaches = Set.of("lucene", "transformer");
        boolean performMlTraining = !nonFeatureApproaches.contains(parameterMap.get(Configuration.dot(prefix, "ml", "exactmatch", "algorithm"))) || !nonFeatureApproaches.contains(parameterMap.get(Configuration.dot(prefix, "ml", "approxmatch", "algorithm")));
        boolean useAllActiveCorporaForTraining = parameterMap.getBoolean(Configuration.dot(prefix, "use_all_corpus_trainsplits"), false);
        List<GeneDocument> partition = this.getTrainingData4Budget4Instance(si, trainWithDev, useAllActiveCorporaForTraining, resourceBudget, maxResourceBudget);
        if (performMlTraining) {
            log.info("Creating features on the training split corresponding to SMAC instance {}", (Object)si);
            log.debug("Using all active corpora for training: {}", (Object)useAllActiveCorporaForTraining);
            assert (!partition.isEmpty()) : "There was no training data returned for instance " + si;
            List<String> machineLearningPrefixes = this.getMachineLearningPrefixes(parameterMap);
            for (String machineLearningPrefix : machineLearningPrefixes) {
                Alphabet dataAlphabet = new Alphabet();
                LabelAlphabet targetAlphabet = new LabelAlphabet();
                assert (parameterMap.containsKey(Configuration.dot(machineLearningPrefix, "algorithm"))) : "There is no setting for algorithm for the machine learning configuation root " + machineLearningPrefix;
                parameterMap.put(Configuration.dot(machineLearningPrefix, "data_alphabet"), dataAlphabet);
                parameterMap.put(Configuration.dot(machineLearningPrefix, "target_alphabet"), targetAlphabet);
            }
            parameterMap.put(Configuration.dot("candidate_retrieval", "train_mode"), true);
            Stats stats = new Stats();
            for (GeneDocument trainDoc : partition) {
                if (!documentsFilter.isEmpty() && !documentsFilter.contains(trainDoc.getId())) continue;
                GeneDocument copy = new GeneDocument(trainDoc);
                copy.getGoldGenes().values().stream().flatMap(Collection::stream).forEach(gm -> stats.incNumGenes());
                geneMapper.map(copy, parameterMap, stats);
            }
            for (String machineLearningPrefix : machineLearningPrefixes) {
                Alphabet da = (Alphabet)parameterMap.get(Configuration.dot(machineLearningPrefix, "data_alphabet"));
                Alphabet ta = (Alphabet)parameterMap.get(Configuration.dot(machineLearningPrefix, "target_alphabet"));
                InstanceList trainingInstances = parameterMap.getMap(Configuration.dot(machineLearningPrefix, "training_instances"), null).values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(() -> new InstanceList(da, ta)));
                if (trainingInstances == null) continue;
                log.info("Training model {} on training split corresponding to SMAC instance {}", (Object)machineLearningPrefix, (Object)si);
                this.train(trainingInstances, parameterMap, machineLearningPrefix, seed);
            }
            for (String machineLearningPrefix : machineLearningPrefixes) {
                ((Alphabet)parameterMap.get(Configuration.dot(machineLearningPrefix, "data_alphabet"))).stopGrowth();
            }
            log.info("Feature creation completed.");
        } else {
            log.debug("Candidate ranking is set to Lucene for exact and approximate matches, no ML training is performed.");
        }
        parameterMap.put(Configuration.dot("candidate_retrieval", "train_mode"), false);
    }
}

