/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.genemodel;

import de.julielab.geneexpbase.GeneExpException;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.configuration.Configuration;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.Acronym;
import de.julielab.geneexpbase.genemodel.AcronymLongform;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.MeshHeading;
import de.julielab.geneexpbase.genemodel.PosTag;
import de.julielab.geneexpbase.genemodel.SpeciesCandidates;
import de.julielab.geneexpbase.genemodel.SpeciesMention;
import de.julielab.java.utilities.spanutils.OffsetMap;
import de.julielab.java.utilities.spanutils.OffsetSet;
import de.julielab.jcore.types.Abbreviation;
import de.julielab.jcore.types.AbbreviationLongform;
import de.julielab.jcore.types.AbstractText;
import de.julielab.jcore.types.Chunk;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.Organism;
import de.julielab.jcore.types.POSTag;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Title;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.types.pubmed.ManualDescriptor;
import de.julielab.jcore.utility.JCoReTools;
import de.julielab.speciesassignment.GeneSpeciesAssigner;
import de.julielab.speciesassignment.services.SpeciesAssignmentFilterImpl;
import de.julielab.speciesassignment.services.SpeciesReferenceMapperImpl;
import de.julielab.speciesassignment.spi.SpeciesAssignmentFilter;
import de.julielab.speciesassignment.spi.SpeciesReferenceMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.search.BooleanQuery;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneDocumentFactory {
    private static final Logger log = LoggerFactory.getLogger(GeneDocumentFactory.class);
    private final SpeciesAssignmentFilter speciesAssignmentFilter;
    private final SpeciesReferenceMapper speciesReferenceMapper;
    private final TermNormalizer normalizer;
    private final GeneSpeciesAssigner speciesAssigner;

    @Inject
    public GeneDocumentFactory(Configuration configuration, GeneSpeciesAssigner speciesAssigner, TermNormalizer normalizer) throws GeneExpException {
        try {
            this.normalizer = normalizer;
            this.speciesAssignmentFilter = new SpeciesAssignmentFilterImpl();
            this.speciesReferenceMapper = new SpeciesReferenceMapperImpl(configuration);
            this.speciesAssigner = speciesAssigner;
        }
        catch (IOException e) {
            throw new GeneExpException(e);
        }
    }

    public GeneDocument createGeneDocument(JCas jCas, Map<String, Matcher> entityMappingTypes, Function<EntityMention, Pair<String, BooleanQuery>> contextFun, Parameters parameters) throws AnalysisEngineProcessException {
        Collection<AbstractText> abstracts;
        Optional<AbstractText> abstractOpt;
        GeneDocument doc = new GeneDocument();
        doc.setTermNormalizer(this.normalizer);
        String docId = JCoReTools.getDocId(jCas);
        doc.setId(docId);
        doc.setDocumentText(jCas.getDocumentText());
        Collection<Title> titles = JCasUtil.select(jCas, Title.class);
        Optional<Title> titleOpt = titles.stream().filter(Objects::nonNull).filter(t -> t.getTitleType() != null).filter(t -> t.getTitleType().equals("document")).findAny();
        if (titleOpt.isPresent()) {
            Title abstractText = titleOpt.get();
            doc.setTitleOffsets(Range.between(abstractText.getBegin(), abstractText.getEnd()));
        }
        if ((abstractOpt = (abstracts = JCasUtil.select(jCas, AbstractText.class)).stream().filter(Objects::nonNull).findAny()).isPresent()) {
            AbstractText abstractText = abstractOpt.get();
            doc.setAbstractOffsets(Range.between(abstractText.getBegin(), abstractText.getEnd()));
        }
        OffsetSet sentences = new OffsetSet();
        for (Object sentence : jCas.getAnnotationIndex(Sentence.type)) {
            sentences.add(Range.between(((Annotation)sentence).getBegin(), ((Annotation)sentence).getEnd()));
        }
        doc.setSentences(sentences);
        ArrayList<PosTag> tags = new ArrayList<PosTag>();
        for (Object token : jCas.getAnnotationIndex(Token.type)) {
            if (((Token)token).getPosTag() == null || ((Token)token).getPosTag().size() <= 0) continue;
            POSTag uimaPosTag = ((Token)token).getPosTag(0);
            PosTag posTag = new PosTag(uimaPosTag.getValue(), Range.between(uimaPosTag.getBegin(), uimaPosTag.getEnd()));
            tags.add(posTag);
        }
        doc.setPosTags(tags);
        OffsetMap<String> chunks = new OffsetMap<String>();
        for (Object chunk : jCas.getAnnotationIndex(Chunk.type)) {
            chunks.put(Range.between(((Annotation)chunk).getBegin(), ((Annotation)chunk).getEnd()), chunk.getClass().getSimpleName().replace("Chunk", ""));
        }
        doc.setChunks(chunks);
        OffsetMap<Acronym> acronyms = new OffsetMap<Acronym>();
        for (Abbreviation abb : jCas.getAnnotationIndex(Abbreviation.type)) {
            AbbreviationLongform longform = abb.getTextReference();
            Acronym acronym = new Acronym(abb.getCoveredText(), abb.getBegin(), abb.getEnd(), new AcronymLongform(longform.getCoveredText(), longform.getBegin(), longform.getEnd()));
            acronyms.put(acronym);
        }
        doc.setAcronyms(acronyms);
        ArrayList<MeshHeading> mesh = new ArrayList<MeshHeading>();
        try {
            de.julielab.jcore.types.ManualDescriptor md = JCasUtil.selectSingle(jCas, de.julielab.jcore.types.ManualDescriptor.class);
            if (md instanceof ManualDescriptor) {
                ManualDescriptor pmMd = (ManualDescriptor)md;
                if (pmMd.getMeSHList() != null) {
                    for (int i = 0; i < pmMd.getMeSHList().size(); ++i) {
                        MeshHeading mh = new MeshHeading(pmMd.getMeSHList(i).getDescriptorName());
                        mesh.add(mh);
                    }
                }
                doc.setMeshHeadings(mesh);
            }
        }
        catch (IllegalArgumentException md) {
            // empty catch block
        }
        OffsetMap<SpeciesMention> speciesMentions = new OffsetMap<SpeciesMention>();
        for (Organism organism : jCas.getAnnotationIndex(Organism.type)) {
            if (organism.getResourceEntryList() == null || organism.getResourceEntryList().size() <= 0) continue;
            SpeciesMention speciesMention = new SpeciesMention(organism.getResourceEntryList(0).getEntryId(), organism.getCoveredText(), organism.getBegin(), organism.getEnd());
            speciesMentions.put(Range.between(organism.getBegin(), organism.getEnd()), speciesMention);
        }
        SpeciesCandidates speciesCandidates = new SpeciesCandidates(doc.getTitleOffsets().getMinimum(), doc.getTitleOffsets().getMaximum(), doc.getMeshHeadings().stream().map(MeshHeading::getTaxonomyIds).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet()), speciesMentions);
        doc.setSpecies(speciesCandidates);
        this.setGenesFromJCas(jCas, doc, entityMappingTypes, contextFun);
        this.speciesAssignmentFilter.filterAssignments(doc);
        doc.getGenes().map(GeneMention::getTaxonomyOccurrences).forEach(this.speciesReferenceMapper::addReferences);
        this.speciesAssignmentFilter.filterAssignments(doc);
        doc.addState(GeneDocument.State.REFERENCE_SPECIES_ADDED);
        return doc;
    }

    private void setGenesFromJCas(JCas aJCas, GeneDocument geneDocument, Map<String, Matcher> entityMappingTypes, Function<EntityMention, Pair<String, BooleanQuery>> contextFun) throws AnalysisEngineProcessException {
        for (String uimaEntityTypeName : entityMappingTypes.keySet()) {
            Type uimaEntityType = aJCas.getTypeSystem().getType(uimaEntityTypeName);
            if (uimaEntityType == null) {
                log.error("The entity mapping type {} is not contained in the current type system.", (Object)uimaEntityTypeName);
                throw new AnalysisEngineProcessException("JCAS_TYPENOTFOUND_ERROR", new Object[]{uimaEntityTypeName});
            }
            Matcher specTypeMatcher = entityMappingTypes.get(uimaEntityTypeName);
            for (Annotation a : aJCas.getAnnotationIndex(uimaEntityType)) {
                EntityMention em;
                try {
                    em = (EntityMention)a;
                }
                catch (ClassCastException e) {
                    String msg = "The passed entity type " + uimaEntityType + " is not a subclass of EntityMention. Only subclasses of EntityMention can take part in the ID mapping of this component.";
                    log.error(msg);
                    throw new AnalysisEngineProcessException(new IllegalArgumentException(msg));
                }
                if (em.getSpecificType() != null && specTypeMatcher.reset(em.getSpecificType()).matches() && !em.getCoveredText().isBlank()) {
                    Pair<String, BooleanQuery> contextAndContextQuery = null;
                    GeneMention gm = this.createGeneMentionFromUimaAnnotation(em, contextAndContextQuery, geneDocument.getId());
                    geneDocument.addGene(gm);
                    continue;
                }
                if (em.getSpecificType() == null) {
                    log.debug("Encountered an entity mention that has no specificType set. Such entities won't be mapped because they don't match any specificType regular expression (see annotator parameter EntityMappingTypes).");
                    continue;
                }
                log.debug("Skipping annotation of type {} because its specificType feature has a non-eligible value: {}", (Object)uimaEntityTypeName, (Object)em.getSpecificType());
            }
        }
        geneDocument.selectAllGenes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GeneMention createGeneMentionFromUimaAnnotation(EntityMention em, Pair<String, BooleanQuery> contextAndContextQuery, String docId) {
        GeneMention.GeneTagger tagger;
        GeneMention gm = new GeneMention(em.getCoveredText(), em.getBegin(), em.getEnd());
        gm.setOriginalMappedObject(em);
        gm.setDocId(docId);
        if (em.getComponentId() == null) throw new IllegalArgumentException("A gene mention without a component ID occurred: " + em);
        String lcname = em.getComponentId().toLowerCase();
        if (lcname.contains("flair")) {
            tagger = GeneMention.GeneTagger.FLAIR;
        } else if (lcname.contains("gazetteer")) {
            tagger = GeneMention.GeneTagger.GAZETTEER;
        } else if (lcname.contains("banner")) {
            tagger = GeneMention.GeneTagger.BANNER;
        } else {
            if (!lcname.contains("proteinconsistencytagger")) throw new IllegalArgumentException("Unhandled entity component ID " + em.getComponentId());
            tagger = GeneMention.GeneTagger.CONSISTENCY_TAGGER;
        }
        gm.setTagger(tagger);
        String type = em.getSpecificType();
        GeneMention.SpecificType specificType = type.equalsIgnoreCase("protein_familiy_or_group") || type.equalsIgnoreCase("familyname") ? GeneMention.SpecificType.FAMILYNAME : (type.equalsIgnoreCase("domainmotif") ? GeneMention.SpecificType.DOMAINMOTIF : GeneMention.SpecificType.GENE);
        gm.setSpecificType(specificType);
        if (em.getConfidence() == null) return gm;
        gm.setSpecificTypeConfidence(Double.valueOf(em.getConfidence()));
        return gm;
    }
}

