/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.genemapper.filtering.families.FamilyUtils;

public class SpecifierDetectionPipe
extends Pipe {
    @Override
    public Instance pipe(Instance inst) {
        Token t = (Token)inst.getData();
        GeneMention gm = (GeneMention)inst.getProperty("gm");
        GeneDocument document = gm.getGeneDocument();
        for (GeneMention gm2 : document.getNonRejectedGenesIterable()) {
            if (gm == gm2) continue;
            String t1 = gm.getNormalizedText();
            String t2 = gm2.getNormalizedText();
            if (!t2.startsWith(t1) || t2.length() <= t1.length()) continue;
            String[] t1split = t1.split("\\s");
            String suffix = t2.substring(t1.length()).trim();
            if (FamilyUtils.isSpecifier(t1split[t1split.length - 1]) || !FamilyUtils.isSpecifier(suffix)) continue;
            t.setFeatureValue("EXISTS_WITH_SPECIFIER", 1.0);
        }
        return inst;
    }
}

