/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.PosTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;

public class PoSBoWPipe
extends Pipe {
    private static final long serialVersionUID = -9008919110526729880L;
    private String prefix;

    public PoSBoWPipe(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Instance pipe(Instance carrier) {
        Token t = (Token)carrier.getData();
        GeneDocument geneDocument = (GeneDocument)carrier.getSource();
        GeneSet gs = (GeneSet)t.getProperty("gs");
        for (GeneMention gm : gs) {
            Collection<PosTag> overlappingPosTags = geneDocument.getOverlappingPosTags(gm.getOffsets());
            for (PosTag pos : overlappingPosTags) {
                Object featureName = null;
                featureName = this.prefix == null ? pos.getTag() : this.prefix + pos.getTag();
                t.setFeatureValue((String)featureName, 1.0);
            }
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.prefix);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.prefix = (String)in.readObject();
    }
}

