/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.PosTag;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PluralPipe
extends Pipe {
    private final String featureName;

    public PluralPipe(String prefix) {
        this.featureName = prefix;
    }

    @Override
    public Instance pipe(Instance inst) {
        Token t = (Token)inst.getData();
        GeneSet geneSet = (GeneSet)t.getProperty("gs");
        GeneDocument geneDocument = (GeneDocument)inst.getSource();
        for (GeneMention gm : geneSet) {
            Collection<PosTag> overlappingPosTags = geneDocument.getOverlappingPosTags(gm.getOffsets());
            String pos = null;
            if (overlappingPosTags instanceof List) {
                pos = ((PosTag)((List)overlappingPosTags).get(overlappingPosTags.size() - 1)).getTag();
            } else {
                Iterator<PosTag> posIt = overlappingPosTags.iterator();
                while (posIt.hasNext()) {
                    pos = posIt.next().getTag();
                }
            }
            if (!pos.equals("NNS")) continue;
            t.setFeatureValue(this.featureName, 1.0);
        }
        return inst;
    }
}

