/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.CandidateFilter;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NonDescriptivePipe
extends Pipe {
    private final String featureName;
    private transient CandidateFilter cf;

    public NonDescriptivePipe(String prefix) throws IOException {
        this.featureName = prefix;
        this.cf = new CandidateFilter();
    }

    @Override
    public Instance pipe(Instance inst) {
        Token t = (Token)inst.getData();
        GeneSet geneSet = (GeneSet)t.getProperty("gs");
        for (GeneMention gm : geneSet) {
            String normalizedText = gm.getNormalizedText();
            String filteredText = gm.getNormalizer().removeNonDescriptives(normalizedText);
            if ((filteredText = TermNormalizer.removeUnspecifieds(filteredText)).equals("") || filteredText.equals("s")) {
                t.setFeatureValue(this.featureName, 1.0);
            }
            if (!CandidateFilter.patternNonDesc.matcher(normalizedText).matches()) continue;
            t.setFeatureValue(this.featureName, 1.0);
        }
        return inst;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.cf = new CandidateFilter();
    }
}

