/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.SpeciesMention;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Range;

public class MentionEnvironmentPipe
extends Pipe {
    private final String prefix;

    public MentionEnvironmentPipe(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Instance pipe(Instance inst) {
        Token t = (Token)inst.getData();
        GeneSet geneSet = (GeneSet)t.getProperty("gs");
        GeneDocument geneDocument = (GeneDocument)inst.getSource();
        for (GeneMention gm : geneSet) {
            Optional<Range> containingChunkOpt = geneDocument.getOverlappingChunks(gm.getOffsets(), "ChunkNP").stream().map(Map.Entry::getKey).findAny();
            if (containingChunkOpt.isPresent()) {
                Range containingChunk = containingChunkOpt.get();
                Map.Entry<Range<Integer>, SpeciesMention> nearestPreviousSpeciesMention = geneDocument.getNearestPreviousSpeciesMention(gm.getOffsets(), null);
                if (nearestPreviousSpeciesMention != null && containingChunk.isOverlappedBy(nearestPreviousSpeciesMention.getKey())) {
                    t.setFeatureValue(this.prefix + "PRECEEDING_SPECIES", 1.0);
                }
            }
            if (gm.getText().matches(".*[0-9]")) {
                t.setFeatureValue("ENV:ENDS_WITH_DIGIT", 1.0);
            }
            if (gm.getText().contains("subunit")) {
                t.setFeatureValue("ENV:CONTAINS_SUBUNIT", 1.0);
            }
            if (!gm.getText().endsWith("subunit")) continue;
            t.setFeatureValue("ENV:ENDS_WITH_SUBUNIT", 1.0);
        }
        return inst;
    }
}

