/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.PosTag;
import de.julielab.genemapper.filtering.families.FamilyUtils;
import edu.ucdenver.ccp.nlp.biolemmatizer.BioLemmatizer;
import edu.ucdenver.ccp.nlp.biolemmatizer.LemmataEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public class LastWordPipe
extends Pipe {
    private static BlockingQueue<BioLemmatizer> bioLemmatizers = new LinkedBlockingDeque<BioLemmatizer>();
    private final String featureName;
    private final boolean useGeneset;

    public LastWordPipe(String prefix, boolean useGeneset) {
        this.featureName = prefix;
        this.useGeneset = useGeneset;
    }

    public LastWordPipe(String prefix) {
        this(prefix, false);
    }

    @Override
    public Instance pipe(Instance inst) {
        GeneMention geneMention;
        GeneSet geneSet;
        Token t = (Token)inst.getData();
        GeneSet geneSet2 = geneSet = this.useGeneset ? (GeneSet)inst.getProperty("gs") : null;
        if (geneSet == null) {
            geneSet = (GeneSet)t.getProperty("gs");
        }
        GeneDocument d = (geneMention = (GeneMention)inst.getProperty("gm")) != null ? geneMention.getGeneDocument() : ((GeneMention)geneSet.iterator().next()).getGeneDocument();
        BioLemmatizer bioLemmatizer = (BioLemmatizer)bioLemmatizers.poll();
        if (bioLemmatizer == null) {
            bioLemmatizer = new BioLemmatizer();
        }
        if (geneSet != null) {
            for (GeneMention gm : geneSet) {
                this.addFeaturesForGeneMention(t, d, gm, bioLemmatizer);
            }
        } else {
            this.addFeaturesForGeneMention(t, d, geneMention, bioLemmatizer);
        }
        bioLemmatizers.offer(bioLemmatizer);
        return inst;
    }

    public void addFeaturesForGeneMention(Token t, GeneDocument d, GeneMention gm, BioLemmatizer bioLemmatizer) {
        ArrayList<PosTag> pos = new ArrayList<PosTag>(d.getOverlappingPosTags(gm.getOffsets()));
        for (int i = pos.size() - 1; i >= 0; --i) {
            PosTag posTag = (PosTag)pos.get(i);
            String word = d.getCoveredText(posTag);
            if (FamilyUtils.isSpecifier(word)) {
                t.setFeatureValue("HAS_SPECIFIER", 1.0);
                continue;
            }
            if (PosTag.stopTags.contains(posTag.getTag())) continue;
            LemmataEntry entry = bioLemmatizer.lemmatizeByLexiconAndRules(word, posTag.getTag());
            Optional<LemmataEntry.Lemma> first = entry.getLemmas().stream().findFirst();
            if (!first.isPresent()) break;
            t.setFeatureValue(this.featureName + "=" + first.get().getLemma(), 1.0);
            t.setFeatureValue(this.featureName + "-POS=" + posTag.getTag(), 1.0);
            break;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        bioLemmatizers = new LinkedBlockingDeque<BioLemmatizer>();
    }
}

