/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.PosTag;
import de.julielab.java.utilities.spanutils.OffsetMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

public class IsFamilyPipe
extends Pipe {
    private static final long serialVersionUID = -9008919110526729880L;
    private String featureName;

    public IsFamilyPipe(String featureName) {
        this.featureName = featureName;
    }

    @Override
    public Instance pipe(Instance carrier) {
        Token t = (Token)carrier.getData();
        GeneDocument geneDocument = (GeneDocument)carrier.getSource();
        GeneSet gs = (GeneSet)t.getProperty("gs");
        for (GeneMention gm : gs) {
            PosTag nextPos;
            OffsetMap<PosTag> posTags = geneDocument.getPosTags();
            Map.Entry higherEntry = posTags.higherEntry(gm.getOffsets());
            if (higherEntry != null && geneDocument.getCoveredText(nextPos = (PosTag)higherEntry.getValue()).equalsIgnoreCase("family")) {
                t.setFeatureValue(this.featureName, 1.0);
            }
            if (!gm.getText().toLowerCase().contains("family")) continue;
            t.setFeatureValue(this.featureName, 1.0);
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.featureName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.featureName = (String)in.readObject();
    }
}

