/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.Token2FeatureVector;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.GeneSets;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.filtering.families.GeneSet2Token;
import de.julielab.genemapper.filtering.families.IsAPipe;
import de.julielab.genemapper.filtering.families.IsFamilyPipe;
import de.julielab.genemapper.filtering.families.MentionPrefixPipe;
import de.julielab.genemapper.filtering.families.NormalizeFeaturesForGeneSetSize;
import de.julielab.genemapper.filtering.families.SetFeatureVectorToGeneSetPipe;
import de.julielab.genemapper.filtering.families.SetInstanceSourceToGeneSetPipe;
import de.julielab.genemapper.filtering.families.SpecifierDetectionPipe;
import de.julielab.genemapper.utils.GeneMapperException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class InstanceListCreator {
    public InstanceList createInstanceList(Stream<GeneDocument> documents, Configuration configuration) throws GeneMapperException {
        List<Pipe> pipes = this.createPipes(configuration);
        InstanceList list = new InstanceList(new SerialPipes(pipes));
        documents.forEach(d -> this.createInstanceList((GeneDocument)d, list));
        return list;
    }

    public InstanceList createInstanceList(Stream<GeneDocument> documents, Alphabet dataAlphabet, Alphabet targetAlphabet) {
        SerialPipes serialPipes = new SerialPipes();
        serialPipes.setDataAlphabet(dataAlphabet);
        serialPipes.setTargetAlphabet(targetAlphabet);
        InstanceList list = new InstanceList(serialPipes);
        documents.flatMap(d -> d.getGeneSets().stream()).forEach(set -> list.add(set.getInstance()));
        return list;
    }

    private InstanceList createInstanceList(GeneDocument document, InstanceList list) {
        GeneSets geneSets = document.getGeneSets();
        for (GeneSet set : geneSets) {
            Instance instance = new Instance(set, null, null, document);
            list.addThruPipe(instance);
            set.setInstance(instance);
        }
        return list;
    }

    public List<Pipe> createPipes(Configuration configuration) throws GeneMapperException {
        ArrayList<Pipe> pipes = new ArrayList<Pipe>();
        try {
            pipes.add(new GeneSet2Token());
            pipes.add(new MentionPrefixPipe("MENTION_PREFIX"));
            pipes.add(new IsAPipe("IS-A"));
            pipes.add(new IsFamilyPipe("IS_FAMILY"));
            pipes.add(new SpecifierDetectionPipe());
            pipes.add(new SetInstanceSourceToGeneSetPipe());
            pipes.add(new Token2FeatureVector(false, true));
            pipes.add(new SetFeatureVectorToGeneSetPipe());
            pipes.add(new NormalizeFeaturesForGeneSetSize());
        }
        catch (IOException e) {
            throw new GeneMapperException(e);
        }
        return pipes;
    }
}

