/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Token;
import com.google.common.collect.HashMultiset;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneSet2Token
extends Pipe {
    private static final Logger log = LoggerFactory.getLogger(GeneSet2Token.class);
    private static final long serialVersionUID = 5719493241780864829L;

    public GeneSet2Token() {
        this.setTargetAlphabet(new LabelAlphabet());
    }

    @Override
    public Instance pipe(Instance inst) {
        GeneSet gs = (GeneSet)inst.getData();
        Token t = new Token(((GeneMention)gs.stream().findAny().get()).getText());
        t.setProperty("gs", gs);
        inst.setData(t);
        LabelAlphabet la = (LabelAlphabet)this.getTargetAlphabet();
        HashMultiset typeSet = HashMultiset.create();
        gs.stream().filter(GeneMention::hasGoldMentions).forEach(gm -> gm.getOverlappingGoldMentions().forEach(gold -> typeSet.add(gold.getSpecificType())));
        if (log.isWarnEnabled() && typeSet.elementSet().size() > 1) {
            log.warn("GeneSet \"{}\" of document {} has multiple mentions out of families, genes and false positive mentions. Mention in the set: {}", gs.getRepresentationText(), ((GeneDocument)inst.getSource()).getId(), gs.stream().map(GeneMention::getText).collect(Collectors.joining(", ")));
        }
        GeneMention.SpecificType majorityType = GeneMention.SpecificType.GENE;
        int max = -1;
        for (GeneMention.SpecificType type : typeSet.elementSet()) {
            int typeCount = typeSet.count((Object)type);
            if (max < 0) {
                max = typeCount;
                majorityType = type;
                continue;
            }
            if (typeCount <= max) continue;
            max = typeCount;
            majorityType = type;
        }
        Label label = la.lookupLabel("NOTHING");
        if (majorityType == GeneMention.SpecificType.GENE) {
            label = la.lookupLabel("GENE");
        } else if (majorityType == GeneMention.SpecificType.FAMILYNAME) {
            label = la.lookupLabel("FAMILY");
        } else if (majorityType == GeneMention.SpecificType.NO_GENE) {
            label = la.lookupLabel("NO_GENE");
        }
        inst.setLabeling(label);
        return inst;
    }
}

