/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import de.julielab.geneexpbase.CandidateFilter;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;

public class GeneMentionFamilyFeatureSetter {
    public static void setFamilyNameFeatures(GeneDocument document) {
        for (GeneMention gm : document.getGenesIterable()) {
            if (gm.getText().endsWith("+") || gm.getEnd() + 1 < document.getDocumentText().length() && document.getDocumentText().charAt(gm.getEnd()) == '+') {
                gm.addFamilyFeature("IS_CELL", 1.0);
            }
            if (gm.getText().endsWith("kinases")) {
                gm.addFamilyFeature("IS_KINASES", 1.0);
            }
            if (gm.getText().endsWith("complex") || gm.getText().endsWith("complexes")) {
                gm.addFamilyFeature("IS_COMPLEX", 1.0);
            }
            if (!CandidateFilter.NON_GENE_WORDS.contains(gm.getText()) && !CandidateFilter.NON_GENE_WORDS.contains(gm.getText().substring(0, gm.getText().length() - 1))) continue;
            gm.addFamilyFeature("IS_NON_GENE_WORD", 1.0);
        }
    }
}

