/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.genemapper.Configuration;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class FamilyMatchPipe
extends Pipe {
    private final boolean useFamilyMatchScoreFeature;
    private final boolean useFamilyMatchRankFeature;
    private final boolean useFamilyMatchExactFeature;
    private final boolean useFamilyMatchFractionFeature;

    public FamilyMatchPipe(Parameters parameters) {
        this.useFamilyMatchScoreFeature = parameters.getBoolean(Configuration.dot("disambiguation", "use_family_match_score_feature"));
        this.useFamilyMatchRankFeature = parameters.getBoolean(Configuration.dot("disambiguation", "use_family_match_rank_feature"));
        this.useFamilyMatchExactFeature = parameters.getBoolean(Configuration.dot("disambiguation", "use_family_match_exact_feature"));
        this.useFamilyMatchFractionFeature = parameters.getBoolean(Configuration.dot("disambiguation", "use_family_match_fraction_feature"));
    }

    @Override
    public Instance pipe(Instance inst) {
        Token t = (Token)inst.getData();
        GeneMention geneMention = (GeneMention)inst.getProperty("gm");
        if (geneMention.matchesFamilyName()) {
            t.setFeatureValue("MATCHES_FAMILY_NAME", 1.0);
            Pair<Integer, Double> candidateFamilyStats = null;
            if (this.useFamilyMatchRankFeature || this.useFamilyMatchFractionFeature) {
                candidateFamilyStats = this.searchCandidatesForFamilyNames(geneMention);
            }
            if (this.useFamilyMatchScoreFeature) {
                double familyNameMatchScore = geneMention.getFamilyNameMatchScore();
                t.setFeatureValue("FAMILY_MATCH_SCORE", familyNameMatchScore);
            }
            if (this.useFamilyMatchRankFeature) {
                t.setFeatureValue("FAMILY_MATCH_RANK", candidateFamilyStats.getLeft().intValue());
            }
            if (this.useFamilyMatchExactFeature && geneMention.isExactFamilyNameMatch()) {
                t.setFeatureValue("FAMILY_EXACT_MATCH", 1.0);
            }
            if (this.useFamilyMatchFractionFeature) {
                t.setFeatureValue("FAMILY_NAME_CANDIDATE_FRACTION", candidateFamilyStats.getRight());
            }
        }
        return inst;
    }

    public Pair<Integer, Double> searchCandidatesForFamilyNames(GeneMention geneMention) {
        int minRank = 50;
        int numFamilyNames = 0;
        int numCandidates = 0;
        Map<String, List<SynHit>> tax2candidates = geneMention.getMentionMappingResult().tax2lexicallyRerankedCandidates;
        if (tax2candidates == null) {
            tax2candidates = geneMention.getMentionMappingResult().tax2originalCandidates;
        }
        for (String tax : geneMention.getTaxonomyIds()) {
            List<SynHit> candidates4tax = tax2candidates.get(tax);
            for (int i = 0; i < candidates4tax.size(); ++i) {
                SynHit synHit = candidates4tax.get(i);
                ++numCandidates;
                if (!synHit.isFamilyName() || i >= minRank) continue;
                minRank = i;
                ++numFamilyNames;
            }
        }
        return new ImmutablePair<Integer, Double>(minRank, (double)numFamilyNames / (double)numCandidates);
    }
}

