/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.PosTag;
import de.julielab.java.utilities.spanutils.OffsetMap;
import de.julielab.java.utilities.spanutils.Span;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Range;

public class ContextPosPipe
extends Pipe {
    private static final long serialVersionUID = -950513387211046959L;
    private String prefix;
    private int position;
    private boolean addWord;
    private static final Set<String> stopTags = new HashSet<String>(Arrays.asList(".", ",", "(", ")", "DET", "``", ":", "''", "-LRB-", "-RRB-", "PRP", "PRP$", "RB", "IN", "DT"));

    public ContextPosPipe(String prefix, int position, boolean addWord) {
        this.prefix = prefix;
        this.position = position;
        this.addWord = addWord;
    }

    @Override
    public Instance pipe(Instance inst) {
        Token t = (Token)inst.getData();
        GeneSet geneSet = (GeneSet)t.getProperty("gs");
        GeneDocument document = (GeneDocument)inst.getSource();
        for (GeneMention gm : geneSet) {
            String tag;
            int currentPosition;
            Range<Integer> sentence = document.getOverlappingSentence(gm);
            OffsetMap<PosTag> posTags = document.getPosTags();
            if (this.position < 0) {
                currentPosition = -1;
                Map.Entry prevPos = posTags.lowerEntry(gm.getOffsets());
                do {
                    tag = null;
                    if (prevPos != null && prevPos.getKey().getMinimum() >= sentence.getMinimum()) {
                        tag = ((PosTag)prevPos.getValue()).getTag();
                        if (!stopTags.contains(tag)) {
                            t.setFeatureValue(this.prefix + currentPosition + "=" + tag, 1.0);
                            if (this.addWord) {
                                t.setFeatureValue(this.prefix + "-word" + currentPosition + "=" + document.getCoveredText((Span)prevPos.getValue()), 1.0);
                            }
                        }
                    } else {
                        t.setFeatureValue(this.prefix + currentPosition + "=<S>", 1.0);
                        if (this.addWord) {
                            t.setFeatureValue(this.prefix + "-word" + currentPosition + "=<S>", 1.0);
                        }
                    }
                    if (tag == null || tag != null && !stopTags.contains(tag)) {
                        --currentPosition;
                    }
                    if (prevPos == null) continue;
                    prevPos = posTags.lowerEntry(prevPos.getKey());
                } while (currentPosition >= this.position);
                continue;
            }
            if (this.position <= 0) continue;
            currentPosition = 1;
            Map.Entry nextPos = posTags.higherEntry(gm.getOffsets());
            do {
                tag = null;
                if (nextPos != null && nextPos.getKey().getMaximum() <= sentence.getMaximum()) {
                    tag = ((PosTag)nextPos.getValue()).getTag();
                    if (!stopTags.contains(tag)) {
                        t.setFeatureValue(this.prefix + currentPosition + "=" + tag, 1.0);
                        if (this.addWord) {
                            t.setFeatureValue(this.prefix + "-word" + currentPosition + "=" + document.getCoveredText((Span)nextPos.getValue()), 1.0);
                        }
                    }
                } else {
                    t.setFeatureValue(this.prefix + currentPosition + "=<S>", 1.0);
                    if (this.addWord) {
                        t.setFeatureValue(this.prefix + "-word" + currentPosition + "=<S>", 1.0);
                    }
                }
                if (tag == null || tag != null && !stopTags.contains(tag)) {
                    ++currentPosition;
                }
                if (nextPos == null) continue;
                nextPos = posTags.higherEntry(nextPos.getKey());
            } while (currentPosition <= this.position);
        }
        return inst;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.prefix);
        out.writeInt(this.position);
        out.writeBoolean(this.addWord);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.prefix = (String)in.readObject();
        this.position = in.readInt();
        this.addWord = in.readBoolean();
    }
}

