/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.GeneMention;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ChemicalSuffix
extends Pipe {
    private static final long serialVersionUID = -3442366946904548L;
    private String prefix;

    @Override
    public Instance pipe(Instance inst) {
        Token t = (Token)inst.getData();
        GeneMention gm = (GeneMention)inst.getProperty("gm");
        String normalizedGeneName = gm.getNormalizedText();
        for (String tokenText : normalizedGeneName.split("\\s+")) {
            String chemPreSuf = null;
            if (tokenText.matches(".*(yl|ylidyne|oyl|sulfonyl)")) {
                chemPreSuf = "-CHEMinlineSuffix-";
            } else if (tokenText.matches("(meth|eth|prop|tetracos).*")) {
                chemPreSuf = "-CHEMalkaneStem-";
            } else if (tokenText.matches("(di|tri|tetra).*")) {
                chemPreSuf = "-CHEMsimpleMultiplier-";
            } else if (tokenText.matches("(benzen|pyridin|toluen).*")) {
                chemPreSuf = "-CHEMtrivialRing-";
            } else if (tokenText.matches(".*(one|ol|carboxylic|amide|ate|acid|ium|ylium|ide|uide|iran|olan|inan|pyrid|acrid|amid|keten|formazan|fydrazin)(s|)")) {
                chemPreSuf = "-CHEMsuffix-";
            }
            if (chemPreSuf == null) continue;
            t.setFeatureValue(chemPreSuf, 1.0);
        }
        return inst;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.prefix);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.prefix = (String)in.readObject();
    }
}

