/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.Acronym;
import de.julielab.geneexpbase.genemodel.AcronymLongform;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Optional;

public class AcronymPipe
extends Pipe {
    private static final long serialVersionUID = -9008919110526729880L;
    private String featureName;

    public AcronymPipe(String featureName) {
        this.featureName = featureName;
    }

    @Override
    public Instance pipe(Instance carrier) {
        Token t = (Token)carrier.getData();
        GeneDocument geneDocument = (GeneDocument)carrier.getSource();
        GeneSet gs = (GeneSet)t.getProperty("gs");
        for (GeneMention gm : gs) {
            Optional<Acronym> acroOpt = geneDocument.getOverlappingAcronyms(gm.getOffsets()).stream().findAny();
            if (acroOpt.isPresent()) {
                Acronym acronym = acroOpt.get();
                if (acronym.getOffsets().equals(gm.getOffsets())) {
                    t.setFeatureValue("IS_ACRONYM", 1.0);
                    continue;
                }
                t.setFeatureValue("HAS_ACRONYM", 1.0);
                continue;
            }
            Optional<AcronymLongform> longOpt = geneDocument.getOverlappingAcronymLongforms(gm.getOffsets()).stream().findAny();
            if (!longOpt.isPresent()) continue;
            AcronymLongform longform = longOpt.get();
            if (longform.getOffsets().equals(gm.getOffsets())) {
                t.setFeatureValue("IS_ACRONYM_LONG", 1.0);
                continue;
            }
            t.setFeatureValue("HAS_ACRONYM_LONG", 1.0);
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.featureName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.featureName = (String)in.readObject();
    }
}

