/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class WordClassPipe
extends Pipe {
    private static final long serialVersionUID = 1L;
    private String featurePrefix;
    private boolean brief;

    public WordClassPipe(String featurePrefix, boolean brief) {
        this.featurePrefix = featurePrefix;
        this.brief = brief;
    }

    @Override
    public Instance pipe(Instance inst) {
        TokenSequence ts = (TokenSequence)inst.getData();
        for (int i = 0; i < ts.size(); ++i) {
            Token t = (Token)ts.get(i);
            String text = t.getText();
            if (this.brief) {
                text = text.replaceAll("[A-Z]+", "A");
                text = text.replaceAll("[a-z]+", "a");
                text = text.replaceAll("[0-9]+", "0");
                text = text.replaceAll("[^A-Za-z0-9]+", "x");
            } else {
                text = text.replaceAll("[A-Z]", "A");
                text = text.replaceAll("[a-z]", "a");
                text = text.replaceAll("[0-9]", "0");
                text = text.replaceAll("[^A-Za-z0-9]", "x");
            }
            String featureName = null;
            featureName = this.featurePrefix + "=" + text;
            t.setFeatureValue(featureName, 1.0);
        }
        return inst;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.featurePrefix);
        out.writeBoolean(this.brief);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.featurePrefix = (String)in.readObject();
        this.brief = in.readBoolean();
    }
}

