/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering;

import de.julielab.genemapper.filtering.StringLengthComparatorAscending;
import de.julielab.genemapper.filtering.StringLengthComparatorDescending;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class StringHelper {
    public static Comparator<String> stringLengthComparatorAscending = new StringLengthComparatorAscending();
    public static Comparator<String> stringLengthComparatorDescending = new StringLengthComparatorDescending();
    public static String[] stopWords = new String[]{"protein", "proteins", "gene", "genes", "cell", "specific", "function", "sequence", "isoform", "isoforms", "characterized", "due", "associated", "role", "activation", "study", "provide", "interact", "structure", "important", "potential", "play", "association", "interaction", "transcription", "level", "similarity", "interaction", "identification", "manner", "show", "cloning", "expressed", "expression", "localization", "appear", "appeared", "confirm", "confirmed", "confirming", "data", "demonstrate", "demonstrated", "demonstrating", "detect", "detected", "detecting", "document", "documented", "documenting", "documents", "evidence", "experiment", "find", "finding", "found", "help", "helps", "helped", "identified", "investigated", "involved", "known", "observe", "observed", "occur", "occurred", "present", "presented", "propose", "proposed", "recent", "recently", "report", "reported", "result", "resulted", "results", "reveal", "revealed", "show", "showed", "shown", "studied", "study", "suggest", "suggested", "suggests", "suggesting", "support", "test", "tested", "thought", "use", "used", "using", "utilized", "new", "novel", "possible", "small", "widely", "a", "after", "against", "all", "also", "although", "among", "an", "and", "and/or", "are", "as", "at", "be", "because", "been", "belong", "between", "both", "but", "by", "can", "could", "did", "do", "does", "during", "each", "either", "for", "from", "furthermore", "had", "has", "have", "however", "in", "is", "it", "its", "itself", "many", "may", "might", "more", "most", "neither", "no", "nor", "not", "of", "on", "only", "or", "other", "our", "same", "such", "than", "that", "the", "their", "there", "thereby", "therefore", "these", "they", "this", "those", "through", "thus", "to", "toward", "towards", "under", "upon", "via", "was", "we", "were", "when", "where", "whereas", "which", "while", "whose", "within", "with", "would"};

    private StringHelper() {
        throw new AssertionError();
    }

    public static String escapeString(String string) {
        return string.replaceAll("([\\+\\-\\*\\(\\)\\[\\]\\?\\{\\}\\\\])", "\\\\$1");
    }

    public static String[] reduceToFirstCharacters(String[] array, int suffixLength) {
        for (int a = 0; a < array.length; ++a) {
            if (array[a].length() <= suffixLength) continue;
            array[a] = array[a].substring(0, suffixLength);
        }
        return array;
    }

    public static String[] concatenate(String[] array1, String[] array2) {
        String[] array = new String[array1.length + array2.length];
        int i = 0;
        for (String s2 : array1) {
            array[i++] = s2;
        }
        for (String s2 : array2) {
            array[i++] = s2;
        }
        return array;
    }

    public static String toSingularForm(String assertedNoun) {
        if (assertedNoun.endsWith("etes")) {
            return assertedNoun;
        }
        if (assertedNoun.endsWith("langerhans")) {
            return assertedNoun;
        }
        if (assertedNoun.endsWith("itis")) {
            return assertedNoun;
        }
        if (assertedNoun.endsWith("ss")) {
            return assertedNoun;
        }
        if (assertedNoun.endsWith("omas")) {
            return assertedNoun.substring(0, assertedNoun.lastIndexOf("omas")) + "oma";
        }
        if (assertedNoun.endsWith("ies")) {
            if (assertedNoun.length() > 4) {
                return assertedNoun.substring(0, assertedNoun.lastIndexOf("ies")) + "y";
            }
            return assertedNoun.substring(0, assertedNoun.lastIndexOf("ies")) + "ie";
        }
        if (assertedNoun.endsWith("ienes")) {
            return assertedNoun.substring(0, assertedNoun.lastIndexOf("ienes")) + "ien";
        }
        if (assertedNoun.endsWith("sses")) {
            return assertedNoun.substring(0, assertedNoun.lastIndexOf("sses")) + "ss";
        }
        if (assertedNoun.endsWith("es") && !assertedNoun.matches("^.*[aeiou]es$")) {
            return assertedNoun.substring(0, assertedNoun.lastIndexOf("es")) + "e";
        }
        if (assertedNoun.endsWith("s") && !assertedNoun.matches("^.*[aeiou]s$")) {
            return assertedNoun.substring(0, assertedNoun.length() - 1);
        }
        if (assertedNoun.endsWith("ae")) {
            return assertedNoun.substring(0, assertedNoun.length() - 1);
        }
        return assertedNoun;
    }

    public static String[] toSingularForms(String[] array) {
        for (int a = 0; a < array.length; ++a) {
            array[a] = StringHelper.toSingularForm(array[a]);
        }
        return array;
    }

    public static boolean equalsIgnorePlural(String one, String two) {
        if (one.equals(two)) {
            return true;
        }
        if (one.equals(two + "s")) {
            return true;
        }
        return two.equals(one + "s");
    }

    public static String splitAndSort(String string) {
        String[] tokens = string.split(" ");
        TreeSet<String> sorter = new TreeSet<String>();
        for (int i = 0; i < tokens.length; ++i) {
            sorter.add(tokens[i]);
        }
        StringBuilder sBuilder = new StringBuilder();
        Iterator tokIt = sorter.iterator();
        while (tokIt.hasNext()) {
            sBuilder.append((String)tokIt.next() + " ");
        }
        return sBuilder.toString().trim();
    }

    public static String[] removeStrings(String[] strings, String[] unwantedStrings) {
        boolean[] keepit = new boolean[strings.length];
        int newsize = strings.length;
        for (int i = 0; i < strings.length; ++i) {
            boolean keep = true;
            for (int j = 0; j < unwantedStrings.length; ++j) {
                if (!strings[i].equals(unwantedStrings[j])) continue;
                keep = false;
                --newsize;
                break;
            }
            keepit[i] = keep;
        }
        String[] remainingWords = new String[newsize];
        int j = 0;
        for (int i = 0; i < strings.length; ++i) {
            if (!keepit[i]) continue;
            remainingWords[j++] = strings[i];
        }
        return remainingWords;
    }

    public static String[] removeStringsIgnoreCase(String[] strings, String[] unwantedStrings) {
        boolean[] keepit = new boolean[strings.length];
        int newsize = strings.length;
        for (int i = 0; i < strings.length; ++i) {
            boolean keep = true;
            for (int j = 0; j < unwantedStrings.length; ++j) {
                if (!strings[i].equalsIgnoreCase(unwantedStrings[j])) continue;
                keep = false;
                --newsize;
                break;
            }
            keepit[i] = keep;
        }
        String[] remainingWords = new String[newsize];
        int j = 0;
        for (int i = 0; i < strings.length; ++i) {
            if (!keepit[i]) continue;
            remainingWords[j++] = strings[i];
        }
        return remainingWords;
    }

    public static String joinStringArray(String[] array, String delimiter) {
        Object result = "";
        if (array.length >= 1) {
            result = array[0];
        }
        for (int i = 1; i < array.length; ++i) {
            result = (String)result + delimiter + array[i];
        }
        return result;
    }

    public static String joinStringList(List<String> list, String delimiter) {
        StringBuffer result = new StringBuffer();
        for (String string : list) {
            if (result.length() > 0) {
                result.append(delimiter);
            }
            result.append(string);
        }
        return result.toString();
    }

    public static String joinStringSet(Set<String> set, String delimiter) {
        StringBuffer result = new StringBuffer();
        for (String string : set) {
            if (result.length() > 0) {
                result.append(delimiter);
            }
            result.append(string);
        }
        return result.toString();
    }

    public static String joinIntegerSet(Set<Integer> set, String delimiter) {
        StringBuffer result = new StringBuffer();
        for (Integer integer : set) {
            if (result.length() > 0) {
                result.append(delimiter);
            }
            result.append(integer);
        }
        return result.toString();
    }

    public static String[] tokenizeToLowerCase(String text) {
        return text.toLowerCase().split("([\\,\\.\\)\\]\\;]?\\s[\\(\\[]?|\\.$)");
    }

    public static void main(String[] args) {
        System.out.println(StringHelper.escapeString("patient + abc - \\ "));
    }
}

