/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.Range;

public class PrevCharPipe
extends Pipe {
    private static final long serialVersionUID = 1401083563798737535L;
    private String prefix;

    public PrevCharPipe(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Instance pipe(Instance carrier) {
        GeneDocument document = (GeneDocument)carrier.getSource();
        TokenSequence ts = (TokenSequence)carrier.getData();
        for (int i = 0; i < ts.size(); ++i) {
            char ch;
            Token token = (Token)ts.get(i);
            GeneMention gm = (GeneMention)token.getProperty("gm");
            Range<Integer> sentence = document.getOverlappingSentence(gm);
            int start = gm.getBegin();
            String featureName = null;
            featureName = start > sentence.getMinimum() ? (Character.isWhitespace(ch = document.getDocumentText().charAt(start - 1)) ? this.prefix + "<WS>" : this.prefix + ch) : this.prefix + "<S>";
            token.setFeatureValue(featureName, 1.0);
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.prefix);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.prefix = (String)in.readObject();
    }
}

