/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.Range;

public class ChunkTypePipe
extends Pipe {
    private static final long serialVersionUID = 4802583029926447079L;
    private String prefix;

    public ChunkTypePipe(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Instance pipe(Instance inst) {
        TokenSequence ts = (TokenSequence)inst.getData();
        GeneDocument document = (GeneDocument)inst.getSource();
        Function<Range, Integer> length = r -> (Integer)r.getMaximum() - (Integer)r.getMinimum();
        for (Token t : ts) {
            GeneMention gm = (GeneMention)t.getProperty("gm");
            Set<Map.Entry<Range<Integer>, String>> chunks = document.getOverlappingChunks(gm.getOffsets());
            Optional longestChunkO = chunks.stream().max((c1, c2) -> (Integer)length.apply((Range)c2.getKey()) - (Integer)length.apply((Range)c1.getKey()));
            if (longestChunkO.isPresent()) {
                Map.Entry longestChunk = (Map.Entry)longestChunkO.get();
                t.setProperty(this.prefix + (String)longestChunk.getValue(), 1.0);
                continue;
            }
            t.setProperty(this.prefix + "<NONE>", 1.0);
        }
        return inst;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.prefix);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.prefix = (String)in.readObject();
    }
}

