/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.evaluation.tools;

import com.google.common.collect.Multimap;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TAPEvaluator {
    public static final File TAP_EXEC_WORKING_DIR = Path.of("src", "main", "resources", "tap_1.3").toFile();
    public static final File TAP_EXEC = Path.of("src", "main", "resources", "tap_1.3", "tap.pl").toFile();
    private static final Logger log = LoggerFactory.getLogger(TAPEvaluator.class);
    public File tapInputDir = new File("tap-input");
    public File tapStatsDir = new File("tap-stats");
    private String[] k = new String[]{"5", "10", "15"};

    public TAPEvaluator() {
    }

    public TAPEvaluator(File tapInputDir, File tapStatsDir) {
        this.tapInputDir = tapInputDir;
        this.tapStatsDir = tapStatsDir;
    }

    public TAPEvaluator(File tapStatsDir) {
        this.tapStatsDir = tapStatsDir;
    }

    public void setK(String[] k) {
        this.k = k;
    }

    public TapResult evaluate(String evaluationRunId, Multimap<String, String> gold, Multimap<String, GeneMention> predicted, Function<SynHit, Double> confidenceFunction) throws IOException {
        File tapInputFile = new File(evaluationRunId + ".txt");
        this.writeTapInputFile(new File(this.tapInputDir.getAbsolutePath(), tapInputFile.getName()), evaluationRunId, gold, predicted, confidenceFunction);
        return this.evaluate(evaluationRunId, this.tapInputDir, tapInputFile);
    }

    public TapResult evaluate(String evaluationRunId, File tapInputDir, File tapInputFile) throws IOException {
        File resultOutputFile = new File(this.tapStatsDir, evaluationRunId + ".txt");
        if (!this.tapStatsDir.exists()) {
            this.tapStatsDir.mkdirs();
        }
        String[] cmd = (String[])Stream.concat(Stream.of("perl", TAP_EXEC.getAbsolutePath(), "-d", tapInputDir.getAbsolutePath(), "-i", tapInputFile.getName(), "-w", resultOutputFile.getAbsolutePath(), "-k"), Arrays.stream(this.k)).toArray(String[]::new);
        Process process = Runtime.getRuntime().exec(cmd, null, TAP_EXEC_WORKING_DIR);
        String[] output = new String[]{};
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                log.error(line);
            }
            process.waitFor(10L, TimeUnit.SECONDS);
            output = FileUtils.readLines(resultOutputFile, "UTF-8").toArray(output);
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return new TapResult(output);
    }

    public List<TapInputList> makeTapInputLists(String evaluationRunId, Multimap<String, String> gold, Multimap<String, GeneMention> predicted, Function<SynHit, Double> confidenceFunction) {
        ArrayList<TapInputList> inputLists = new ArrayList<TapInputList>(predicted.keys().size());
        for (String docId : predicted.keySet()) {
            TapInputList inputList = new TapInputList(evaluationRunId + "_" + docId);
            HashSet<String> idsInDoc = gold.containsKey(docId) ? new HashSet<String>(gold.get(docId)) : Collections.emptySet();
            Collection<GeneMention> predictedInDoc = predicted.get(docId);
            for (GeneMention gm : predictedInDoc) {
                for (SynHit result : gm.getMentionMappingResult().resultEntries) {
                    int relevance = idsInDoc.contains(result.getId()) ? 1 : 0;
                    double confidence = confidenceFunction.apply(result);
                    inputList.add(new TapInputLine(relevance, confidence));
                }
            }
            Collections.sort(inputList, Comparator.comparingDouble(l -> l.confidence));
            inputLists.add(inputList);
        }
        Collections.sort(inputLists, Comparator.comparing(l -> l.listname));
        return inputLists;
    }

    public void writeTapInputFile(File tapInputFile, String evaluationRunId, Multimap<String, String> gold, Multimap<String, GeneMention> predicted, Function<SynHit, Double> confidenceFunction) throws IOException {
        if (!this.tapInputDir.exists()) {
            this.tapInputDir.mkdirs();
        }
        if (gold == null) {
            throw new IllegalArgumentException("Gold data is null.");
        }
        if (predicted == null) {
            throw new IllegalArgumentException("Prediction data is null.");
        }
        if (gold.isEmpty()) {
            log.warn("The gold data is empty.");
        }
        if (predicted.isEmpty()) {
            log.warn("The predicted data is empty.");
        }
        try (BufferedWriter bw = FileUtilities.getWriterToFile(tapInputFile);){
            List<TapInputList> inputLists = this.makeTapInputLists(evaluationRunId, gold, predicted, confidenceFunction);
            for (TapInputList inputList : inputLists) {
                bw.write(inputList.getListname());
                bw.newLine();
                bw.write(String.valueOf(inputList.size()));
                bw.newLine();
                for (TapInputLine inputLine : inputList) {
                    bw.write(inputLine.toTapInputLine());
                    bw.newLine();
                }
                bw.newLine();
            }
        }
    }

    public static class TapResult
    extends HashMap<Integer, TapResultList> {
        public TapResult(String[] output) {
            this.parseTapProgramOutput(output);
        }

        private void parseTapProgramOutput(String[] lines) {
            boolean inlist = false;
            boolean newlist = false;
            TapResultList currentList = null;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.isBlank()) {
                    inlist = false;
                }
                if (inlist) {
                    TapResultRecord tapResultRecord;
                    String[] split = line.split("\\t");
                    TapResultRecord tapResultRecord2 = tapResultRecord = newlist ? new TapResultRecord(split[0], split[1], Double.parseDouble(split[2])) : new TapResultRecord(split[0], currentList.getListresult().getEpq(), currentList.getListresult().getThreshold(), Double.parseDouble(split[1]));
                    if (newlist) {
                        currentList = new TapResultList(tapResultRecord.getListname());
                        currentList.setListresult(tapResultRecord);
                        this.put(currentList.getListresult().epq, currentList);
                    } else {
                        currentList.add(tapResultRecord);
                    }
                }
                newlist = false;
                if (line.startsWith("GN Input file")) {
                    inlist = true;
                    newlist = true;
                }
                if (!line.startsWith("Individual Retrieval")) continue;
                inlist = true;
            }
        }
    }

    public static class TapResultList
    extends ArrayList<TapResultRecord> {
        private final String listname;
        private TapResultRecord listresult;

        public TapResultList(String listname) {
            this.listname = listname;
        }

        public String getListname() {
            return this.listname;
        }

        public TapResultRecord getListresult() {
            return this.listresult;
        }

        public void setListresult(TapResultRecord listresult) {
            this.listresult = listresult;
        }
    }

    public static class TapResultRecord {
        private static final Matcher epqThresholdMatcher = Pattern.compile("([0-9]+)\\s*\\(([0-9.]+)\\)").matcher("");
        private final String listname;
        private final int epq;
        private final double threshold;
        private final double tap;

        public TapResultRecord(String listname, String epqAndThreshold, double tap) {
            this.listname = listname;
            epqThresholdMatcher.reset(epqAndThreshold);
            if (!epqThresholdMatcher.matches()) {
                throw new IllegalArgumentException("The line '" + epqAndThreshold + "' does not adhere to the expected output format of the tap.pl tool.");
            }
            this.epq = Integer.parseInt(epqThresholdMatcher.group(1));
            this.threshold = Double.parseDouble(epqThresholdMatcher.group(2));
            this.tap = tap;
        }

        public TapResultRecord(String listname, int epq, double threshold, double tap) {
            this.listname = listname;
            this.epq = epq;
            this.threshold = threshold;
            this.tap = tap;
        }

        public static Matcher getEpqThresholdMatcher() {
            return epqThresholdMatcher;
        }

        public String getListname() {
            return this.listname;
        }

        public int getEpq() {
            return this.epq;
        }

        public double getThreshold() {
            return this.threshold;
        }

        public double getTap() {
            return this.tap;
        }
    }

    public static class TapInputLine {
        double confidence;
        private final int relevance;

        public TapInputLine(int relevance, double confidence) {
            this.relevance = relevance;
            this.confidence = confidence;
        }

        public int getRelevance() {
            return this.relevance;
        }

        public double getConfidence() {
            return this.confidence;
        }

        public String toTapInputLine() {
            return this.relevance + " " + this.confidence;
        }
    }

    public static class TapInputList
    extends ArrayList<TapInputLine> {
        private final String listname;

        public TapInputList(String listname) {
            this.listname = listname;
        }

        public String getListname() {
            return this.listname;
        }
    }
}

