/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.evaluation.tools;

import com.google.inject.Guice;
import com.google.inject.Injector;
import de.julielab.gene.candidateretrieval.CandidateRetrieval;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.GeneMapper;
import de.julielab.genemapper.ioc.GeneMappingModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.search.spell.SpellChecker;

public class InteractiveSpellingChecker {
    public static void main(String[] args) throws Exception {
        String propertiesFile = "src/main/resources/genemapper.properties";
        Injector injector = Guice.createInjector(new GeneMappingModule(new Configuration(new File(propertiesFile))));
        GeneMapper mapper = injector.getInstance(GeneMapper.class);
        CandidateRetrieval candidateRetrieval = injector.getInstance(CandidateRetrieval.class);
        SpellChecker sc = candidateRetrieval.getSpellingChecker();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            block4: while (true) {
                System.out.println("Enter term:");
                String input = br.readLine();
                String normalizedTerm = mapper.getMappingCore().getTermNormalizer().normalize(input);
                System.out.println("Normalized term: " + normalizedTerm);
                if (sc.exist(input)) {
                    System.out.println("The word " + input + " exists in the index.");
                }
                String[] suggestSimilar = sc.suggestSimilar(input, 5);
                int i = 0;
                while (true) {
                    if (i >= suggestSimilar.length) continue block4;
                    String suggestion = suggestSimilar[i];
                    System.out.println(suggestion);
                    ++i;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (sc != null) {
                try {
                    sc.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }
}

