/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.evaluation.tools;

import de.julielab.geneexpbase.data.GeneInformation;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.GeneMapper;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenelistToTaxonomyListConverter {
    private static final Logger log = LoggerFactory.getLogger(GenelistToTaxonomyListConverter.class);

    public static void main(String[] args) throws Exception {
        File gnormGeneList = new File("/Users/faessler/Coding/git/jcore-gene-mapper-ae/jcore-gene-mapper-ae/data/eval_data/bc3_data/trainset2/trainset2.genelist");
        File gnormTaxList = new File("/Users/faessler/Coding/git/jcore-gene-mapper-ae/jcore-gene-mapper-ae/data/eval_data/bc3_data/trainset2/trainset2.taxlist");
        String propertiesFile = "data/eval_data/genemapper.properties";
        Configuration configuration = new Configuration(new File(propertiesFile));
        GeneMapper mapper = null;
        log.info("Reading genelist from {}", (Object)gnormGeneList);
        try (BufferedReader br = FileUtilities.getReaderFromFile(gnormGeneList);){
            List taxRecords = br.lines().map(l -> l.split("\t")).map(record -> GenelistToTaxonomyListConverter.replaceGeneByTaxId(record, mapper)).collect(Collectors.toList());
            log.info("Got {} gene records", (Object)taxRecords.size());
            log.info("Writing taxonomy records to {}", (Object)gnormTaxList);
            try (BufferedWriter bw = FileUtilities.getWriterToFile(gnormTaxList);){
                for (String[] record2 : taxRecords) {
                    bw.write(Stream.of(record2).collect(Collectors.joining("\t")));
                    bw.newLine();
                }
            }
        }
    }

    private static String[] replaceGeneByTaxId(String[] record, GeneMapper mapper) {
        String geneId = record[1];
        String taxId = GeneInformation.replaceGeneByTaxId(geneId, mapper.getMappingCore().getCandidateRetrieval());
        if (taxId == null) {
            log.warn("Got null taxonomy ID for gene id " + geneId);
        }
        record[1] = taxId;
        return record;
    }
}

