/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.evaluation.tools;

import de.julielab.geneexpbase.data.GeneInformation;
import de.julielab.genemapper.GeneMapper;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenelistByTaxonomyFilter {
    private static final Logger log = LoggerFactory.getLogger(GenelistByTaxonomyFilter.class);

    public static void main(String[] args) throws Exception {
        File gnormGeneList = new File("data/eval_data/gnormplus_data/bc2train/bc2train_updatedids.genelist");
        File gnormTaxList = new File("data/eval_data/gnormplus_data/bc2train/bc2train.taxlist");
        String propertiesFile = "data/eval_data/gnormplus_data/genemapper.properties";
        GeneMapper mapper = null;
        Object luceneCandidateRetrieval = null;
        log.info("Reading genelist from {}", (Object)gnormGeneList);
        try (BufferedReader br = FileUtilities.getReaderFromFile(gnormGeneList);){
            for (String line : () -> br.lines().iterator()) {
                String[] stringArray = line.split("\t");
            }
            List taxRecords = br.lines().map(l -> l.split("\t")).map(record -> GenelistByTaxonomyFilter.replaceGeneByTaxId(record, mapper)).collect(Collectors.toList());
            log.info("Got {} gene records", (Object)taxRecords.size());
            log.info("Writing taxonomy records to {}", (Object)gnormTaxList);
            try (BufferedWriter bw = FileUtilities.getWriterToFile(gnormTaxList);){
                for (String[] record2 : taxRecords) {
                    bw.write(Stream.of(record2).collect(Collectors.joining("\t")));
                    bw.newLine();
                }
            }
        }
    }

    private static String[] replaceGeneByTaxId(String[] record, GeneMapper mapper) {
        String geneId = record[1];
        String taxId = GeneInformation.replaceGeneByTaxId(geneId, mapper.getMappingCore().getCandidateRetrieval());
        if (taxId == null) {
            throw new IllegalStateException("Got null taxonomy ID for gene id " + geneId);
        }
        record[1] = taxId;
        return record;
    }
}

