/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.evaluation.tools;

import java.text.DecimalFormat;

public class DocResult {
    int tp;
    int fp;
    int fn;

    public DocResult(int tp, int fp, int fn) {
        this.tp = tp;
        this.fp = fp;
        this.fn = fn;
    }

    public DocResult() {
    }

    public double getRecall() {
        double ret = this.tp + this.fn > 0 ? (double)this.tp / (double)(this.tp + this.fn) : 0.0;
        return ret;
    }

    public double getPrecision() {
        double ret = this.tp + this.fp > 0 ? (double)this.tp / (double)(this.tp + this.fp) : 0.0;
        return ret;
    }

    public double getFscore() {
        double recall;
        double precision = this.getPrecision();
        double ret = precision + (recall = this.getRecall()) > 0.0 ? 2.0 * precision * recall / (precision + recall) : 0.0;
        return ret;
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("0.000");
        return "R: " + df.format(this.getRecall()) + "\tP: " + df.format(this.getPrecision()) + "\tF: " + df.format(this.getFscore());
    }

    public String toDetailedString() {
        return "tp: " + this.tp + "\tfp: " + this.fp + "\tfn: " + this.fn + "\t|\t" + this;
    }

    public int getFn() {
        return this.fn;
    }

    public void setFn(int fn) {
        this.fn = fn;
    }

    public int getFp() {
        return this.fp;
    }

    public void setFp(int fp) {
        this.fp = fp;
    }

    public int getTp() {
        return this.tp;
    }

    public void setTp(int tp) {
        this.tp = tp;
    }
}

