/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.evaluation;

import com.google.inject.Guice;
import com.google.inject.Injector;
import de.julielab.evaluation.entities.EntityEvaluationResults;
import de.julielab.evaluation.entities.EntityEvaluator;
import de.julielab.evaluation.entities.EvaluationData;
import de.julielab.evaluation.entities.EvaluationDataEntry;
import de.julielab.geneexpbase.configuration.Configuration;
import de.julielab.geneexpbase.data.DocumentLoader;
import de.julielab.geneexpbase.data.DocumentLoadingException;
import de.julielab.geneexpbase.data.DocumentSourceFileRegistry;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.ioc.ServicesShutdownHub;
import de.julielab.genemapper.disambig.wikipedia.WikipediaEntityClassDecisionBear;
import de.julielab.genemapper.filtering.UnspecificNameFilter;
import de.julielab.genemapper.hpo.GnHpoServer;
import de.julielab.genemapper.ioc.GeneMappingModule;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class GNormPlusBC2GNTrainEntityFiltering {
    public static void main(String[] args) throws DocumentLoadingException, IOException {
        GNormPlusBC2GNTrainEntityFiltering filtering = new GNormPlusBC2GNTrainEntityFiltering();
        filtering.run();
    }

    private void run() throws DocumentLoadingException, IOException {
        Injector injector = Guice.createInjector(new GeneMappingModule(new Configuration(GnHpoServer.CONFIG_WITH_SA_AND_LUCENE_SETTINGS)));
        DocumentLoader documentLoader = injector.getInstance(DocumentLoader.class);
        Stream<GeneDocument> documents = documentLoader.getDocuments(DocumentSourceFileRegistry.gnpBc2gnTestFlairProGeneGnpEntitiesConsistencyLongerGazetteer());
        EvaluationData gold = new EvaluationData();
        EvaluationData pred = new EvaluationData();
        UnspecificNameFilter filter = new UnspecificNameFilter();
        for (GeneDocument doc : () -> documents.iterator()) {
            doc.clearSelectedGenes();
            doc.selectGeneMentionsByTagger(GeneMention.GeneTagger.FLAIR_JPG_GNP_ENTITIES, GeneMention.GeneTagger.EXPANSION_TAGGER, GeneMention.GeneTagger.CONSISTENCY_TAGGER);
            doc.getGoldGenes().values().stream().flatMap(Collection::stream).map(gm -> new EvaluationDataEntry(gm.getDocId(), "0", gm.getBegin(), gm.getEnd())).forEach(gold::add);
            doc.getGenes().filter(gm -> gm.getSpecificType() == GeneMention.SpecificType.GENE).filter(Predicate.not(GeneMention::isRejected)).map(gm -> {
                EvaluationDataEntry e = new EvaluationDataEntry(gm.getDocId(), "0", gm.getBegin(), gm.getEnd());
                e.setReferenceObject(gm);
                return e;
            }).forEach(pred::add);
        }
        Properties evaluatorSettings = new Properties();
        evaluatorSettings.setProperty("comparison-type", EvaluationDataEntry.ComparisonType.OVERLAP.name());
        evaluatorSettings.setProperty("overlap-type", EvaluationDataEntry.OverlapType.PERCENT.name());
        evaluatorSettings.setProperty("overlap-size", "100");
        EntityEvaluator evaluator = new EntityEvaluator(evaluatorSettings);
        EntityEvaluationResults evalResults = evaluator.evaluate(gold, pred);
        String evalReport = evalResults.getOverallResult().getEvaluationReportShort();
        Stream<EvaluationDataEntry> fps = evalResults.getOverallResult().getFpEvaluationDataEntriesMentionWise();
        this.printDerivedWikipediaClasses(injector, fps, "FPs");
        Stream<EvaluationDataEntry> tps = evalResults.getOverallResult().getTpEvaluationDataEntriesMentionWise();
        System.out.println(evalReport);
        ServicesShutdownHub shutdownHub = injector.getInstance(ServicesShutdownHub.class);
        shutdownHub.shutdown();
    }

    private void printDerivedWikipediaClasses(Injector injector, Stream<EvaluationDataEntry> fps, String errorclass) {
        Iterator iterator = fps.iterator();
        WikipediaEntityClassDecisionBear wikiIndex = injector.getInstance(WikipediaEntityClassDecisionBear.class);
        int numFamilies = 0;
        int all = 0;
        while (iterator.hasNext()) {
            ++all;
            EvaluationDataEntry fp = (EvaluationDataEntry)iterator.next();
            GeneMention gm = (GeneMention)fp.getReferenceObject();
            GeneMention.SpecificType specificType = wikiIndex.lookupEntityType(gm);
            if (specificType == GeneMention.SpecificType.COMPLEX || specificType == GeneMention.SpecificType.FAMILYNAME || specificType == GeneMention.SpecificType.GROUP || specificType == GeneMention.SpecificType.NO_GENE) {
                ++numFamilies;
            }
            System.out.println(gm + " " + specificType);
        }
        System.out.println("Num Families/Groups in " + errorclass + ": " + numFamilies + " (" + (double)numFamilies / (double)all * 100.0 + "%)");
    }
}

