/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.disambig.wikipedia;

import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.scoring.JaroWinklerScorer;
import de.julielab.genemapper.disambig.wikipedia.WikipediaEntity;
import de.julielab.genemapper.utils.GeneMapperException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.FSDirectory;

public class WikipediaIndexReader {
    public static Set<String> UNIT_TEST_WIKIPEDIA_TITLES_ACCUMULATION_SET;
    private final TermNormalizer normalizer;
    private final IndexSearcher indexSearcher;

    @Inject
    public WikipediaIndexReader(@Named(value="wikipedia_index") String wikipediaIndexPath, TermNormalizer normalizer) throws GeneMapperException {
        this.normalizer = normalizer;
        try {
            String indexPath = wikipediaIndexPath;
            DirectoryReader reader = DirectoryReader.open(FSDirectory.open(Paths.get(indexPath, new String[0])));
            this.indexSearcher = new IndexSearcher(reader);
        }
        catch (IOException e) {
            throw new GeneMapperException(e);
        }
    }

    public static void main(String[] args) throws IOException, GeneMapperException {
        TermNormalizer normalizer = new TermNormalizer();
        WikipediaIndexReader wikipediaIndexReader = new WikipediaIndexReader("../built-resources/indexes/wikipediaIndex", normalizer);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        block0: while (true) {
            System.out.println("Enter term:");
            String input = br.readLine();
            String normalize = normalizer.normalize(input);
            System.out.println("Normalized term: " + normalize);
            List<WikipediaEntity> pairs = wikipediaIndexReader.searchWikipedia(normalize);
            Iterator<WikipediaEntity> iterator = pairs.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                WikipediaEntity p = iterator.next();
                System.out.println(p);
            }
            break;
        }
    }

    public List<WikipediaEntity> searchWikipedia(String normalizedName) {
        JaroWinklerScorer scorer = new JaroWinklerScorer();
        ArrayList<WikipediaEntity> ret = new ArrayList<WikipediaEntity>();
        try {
            String[] tokens;
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (String token : tokens = normalizedName.split("\\s+")) {
                builder.add(new TermQuery(new Term("title", token)), BooleanClause.Occur.SHOULD);
            }
            BooleanQuery query = builder.build();
            TopDocs topDocs = this.indexSearcher.search((Query)query, 10);
            for (ScoreDoc doc : topDocs.scoreDocs) {
                Document luceneDoc = this.indexSearcher.doc(doc.doc);
                String[] titleAndRedirects = (String[])Arrays.stream(luceneDoc.getFields("title")).map(IndexableField::stringValue).toArray(String[]::new);
                String title = titleAndRedirects[0];
                String bestMatchingTitle = null;
                double bestMatchingScore = -1.0;
                for (int i = 0; i < titleAndRedirects.length; ++i) {
                    String titleAndRedirect = titleAndRedirects[i];
                    String normalizedTitle = this.normalizer.normalize(titleAndRedirect);
                    double score = scorer.getScore(normalizedTitle, normalizedName);
                    if (!(score > bestMatchingScore)) continue;
                    bestMatchingTitle = titleAndRedirect;
                    bestMatchingScore = score;
                }
                List<String> entities = Arrays.stream(luceneDoc.getFields("entities")).map(IndexableField::stringValue).collect(Collectors.toList());
                List<String> mentionedWikipediaEntities = Arrays.stream(luceneDoc.getFields("mentionedpagetitles")).map(IndexableField::stringValue).collect(Collectors.toList());
                boolean titleMentionedInPlural = Optional.ofNullable(luceneDoc.getField("titleisinplural")).map(IndexableField::stringValue).map(Boolean::parseBoolean).orElse(false);
                boolean titleHasUnspecificArticle = Optional.ofNullable(luceneDoc.getField("hasunspectitle")).map(IndexableField::stringValue).map(Boolean::parseBoolean).orElse(false);
                ret.add(new WikipediaEntity(doc.score, title, bestMatchingTitle, bestMatchingScore, entities, mentionedWikipediaEntities, titleMentionedInPlural, titleHasUnspecificArticle));
                if (UNIT_TEST_WIKIPEDIA_TITLES_ACCUMULATION_SET == null) continue;
                UNIT_TEST_WIKIPEDIA_TITLES_ACCUMULATION_SET.add(title);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ret.sort(Comparator.comparing(page -> this.normalizer.normalize(page.getBestMatchingTitle()).equals(normalizedName)).thenComparing(WikipediaEntity::getScore).reversed());
        return ret;
    }
}

