/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.disambig;

import de.julielab.gene.candidateretrieval.GeneRecordHit;
import de.julielab.gene.candidateretrieval.GeneRecordQueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.genemapper.disambig.SynHitListFusion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class RRFSynHitListFusion
implements SynHitListFusion {
    private final BiFunction<SynHit, SynHit, SynHit> synHitMergingFunction = (sh1, sh2) -> {
        if (sh1.isExactMatch() ^ sh2.isExactMatch()) {
            if (sh1.isExactMatch()) {
                return sh1;
            }
            return sh2;
        }
        if (sh1.isExactMatch() && sh2.isExactMatch() && sh1 instanceof GeneRecordHit && sh1 instanceof GeneRecordHit) {
            GeneRecordHit grh1 = (GeneRecordHit)sh1;
            GeneRecordHit grh2 = (GeneRecordHit)sh2;
            if (!grh1.getSynonymField().equals(grh2.getSynonymField())) {
                int sh1fieldindex;
                int sh2fieldindex = GeneRecordQueryGenerator.ALL_FIELDS.length - 1;
                for (sh1fieldindex = GeneRecordQueryGenerator.ALL_FIELDS.length - 1; sh1fieldindex >= 0 && !grh1.getSynonymField().equals(GeneRecordQueryGenerator.ALL_FIELDS[sh1fieldindex]); --sh1fieldindex) {
                }
                while (sh2fieldindex >= 0 && !grh2.getSynonymField().equals(GeneRecordQueryGenerator.ALL_FIELDS[sh2fieldindex])) {
                    --sh2fieldindex;
                }
                if (sh1fieldindex < sh2fieldindex) {
                    return sh1;
                }
                if (sh2fieldindex < sh1fieldindex) {
                    return sh2;
                }
            }
        }
        if (sh1.getOverallScore() != 0.0 && sh2.getOverallScore() != 0.0) {
            if (sh1.getOverallScore() > sh2.getOverallScore()) {
                return sh1;
            }
            if (sh2.getOverallScore() > sh1.getOverallScore()) {
                return sh1;
            }
        }
        if (sh1.getLexicalScore() > sh2.getLexicalScore()) {
            return sh1;
        }
        return sh2;
    };

    @Override
    public List<SynHit> fuse(List<List<SynHit>> candidateLists) {
        ArrayList rankScoreMaps = new ArrayList();
        HashMap<Object, SynHit> retrievedDocIds = new HashMap<Object, SynHit>();
        for (List<SynHit> list : candidateLists) {
            HashMap<Object, Double> reciprocalScores = new HashMap<Object, Double>();
            rankScoreMaps.add(reciprocalScores);
            for (int i = 0; i < list.size(); ++i) {
                SynHit synHit = list.get(i);
                String geneId = synHit.getId();
                double d = 1.0 / (double)(60 + i);
                reciprocalScores.put(geneId, d);
                retrievedDocIds.merge(geneId, synHit, this.synHitMergingFunction);
            }
        }
        ArrayList<SynHit> fusedList = new ArrayList<SynHit>();
        for (String geneId : retrievedDocIds.keySet()) {
            double score = 0.0;
            for (Map map : rankScoreMaps) {
                Double scoreFromList = (Double)map.get(geneId);
                if (scoreFromList == null) continue;
                score += scoreFromList.doubleValue();
            }
            SynHit synHit = (SynHit)retrievedDocIds.get(geneId);
            SynHit synHit2 = synHit.clone();
            synHit2.setOverallScore(score);
            fusedList.add(synHit2);
        }
        Collections.sort(fusedList, Comparator.comparingDouble(SynHit::getOverallScore).reversed());
        return fusedList;
    }
}

