/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.disambig;

import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.MentionMappingResult;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.disambig.RRFSynHitListFusion;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DypsisRankingMerger {
    public static void mergeLexicalWithSemanticRanking(GeneDocument document, Parameters parameters) {
        String fuseMethod = parameters.getString(Configuration.dot("disambiguation", "lex_context_fuse_method"));
        if (fuseMethod.equals("rank_fusion")) {
            for (GeneMention gm : document.getNonRejectedGenesIterable()) {
                MentionMappingResult mmr = gm.getMentionMappingResult();
                for (String taxId : gm.getTaxonomyIds()) {
                    List semanticallyRankedCandidates;
                    List lexicallyRankedCandidates = mmr.tax2lexicallyRerankedCandidates.getOrDefault(taxId, Collections.emptyList());
                    List<SynHit> fusedLists = new RRFSynHitListFusion().fuse(List.of(lexicallyRankedCandidates, semanticallyRankedCandidates = mmr.tax2semanticallyOrderedCandidates.getOrDefault(taxId, Collections.emptyList())));
                    if (!fusedLists.isEmpty()) {
                        mmr.setFinalRankedCandidates(taxId, fusedLists);
                        continue;
                    }
                    mmr.setFinalRankedCandidates(taxId, List.of(MentionMappingResult.REJECTION));
                    mmr.setRejectReason(taxId, MentionMappingResult.RejectReason.DISAMBIGUATION_HAD_NO_RESULT);
                }
            }
        } else if (fuseMethod.equals("balanced_scores")) {
            for (GeneMention gm : document.getNonRejectedGenesIterable()) {
                MentionMappingResult mmr = gm.getMentionMappingResult();
                for (String taxId : gm.getTaxonomyIds()) {
                    if (!mmr.tax2balancedScoreOrderedCandidates.containsKey(taxId)) continue;
                    List<SynHit> balancedRerankedHits = mmr.tax2balancedScoreOrderedCandidates.get(taxId);
                    if (!balancedRerankedHits.isEmpty()) {
                        mmr.setFinalRankedCandidates(taxId, balancedRerankedHits);
                        continue;
                    }
                    mmr.setFinalRankedCandidates(taxId, List.of(MentionMappingResult.REJECTION));
                    mmr.setRejectReason(taxId, MentionMappingResult.RejectReason.DISAMBIGUATION_HAD_NO_RESULT);
                }
            }
        } else if (fuseMethod.equals("context_scores")) {
            for (GeneMention gm : document.getNonRejectedGenesIterable()) {
                MentionMappingResult mmr = gm.getMentionMappingResult();
                Map<String, List<SynHit>> tax2semanticallyOrderedCandidates = mmr.tax2semanticallyOrderedCandidates;
                for (String taxId : gm.getTaxonomyIds()) {
                    List<SynHit> semanticallyRankedCandidates = tax2semanticallyOrderedCandidates.get(taxId);
                    if (!semanticallyRankedCandidates.isEmpty()) {
                        mmr.setFinalRankedCandidates(taxId, semanticallyRankedCandidates);
                        continue;
                    }
                    mmr.setFinalRankedCandidates(taxId, List.of(MentionMappingResult.REJECTION));
                    mmr.setRejectReason(taxId, MentionMappingResult.RejectReason.DISAMBIGUATION_HAD_NO_RESULT);
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown lexical-contextual fusion method: " + fuseMethod);
        }
    }
}

