/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.disambig;

import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.MentionMappingResult;
import de.julielab.genemapper.Configuration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Range;

public class DypsisCandidateRejector {
    public static void rejectLowScoreResults(GeneDocument document, Parameters parameters) {
        if (parameters.getBoolean(Configuration.dot("disambiguation", "do_low_score_rejection"), false)) {
            double exactMatchRejectionThreshold = DypsisCandidateRejector.getExactMatchThreshold(Configuration.dot("disambiguation", "rejection"), parameters);
            double approxMatchRejectionThreshold = DypsisCandidateRejector.getApproxMatchThreshold(Configuration.dot("disambiguation", "rejection"), parameters);
            for (GeneMention gm : document.getNonRejectedGenesIterable()) {
                for (String taxId : gm.getTaxonomyIds()) {
                    double rejectionThreshold;
                    MentionMappingResult mmr = gm.getMentionMappingResult();
                    SynHit resultEntry = mmr.getResultCandidate(taxId);
                    double d = rejectionThreshold = resultEntry.isExactMatch() ? exactMatchRejectionThreshold : approxMatchRejectionThreshold;
                    double overallScore = resultEntry.getOverallScore();
                    if (!(overallScore < rejectionThreshold)) continue;
                    mmr.setFinalRankedCandidates(taxId, List.of(MentionMappingResult.REJECTION));
                    mmr.setRejectReason(taxId, MentionMappingResult.RejectReason.DISAMBIGUATION_BELOW_THRESHOLD);
                }
            }
        }
    }

    private static double getExactMatchThreshold(String prefix, Parameters parameters) {
        return parameters.getDouble(Configuration.dot(prefix, "threshold_exact_matches"));
    }

    private static double getApproxMatchThreshold(String prefix, Parameters parameters) {
        return parameters.getDouble(Configuration.dot(prefix, "threshold_approx_matches"));
    }

    public static void rejectFamilyMentions(GeneDocument document, Parameters parameters) {
        int rejectFamilyHitAtRankApprox;
        int rejectFamilyHitAtRankExact;
        if (parameters.getBoolean(Configuration.dot("disambiguation", "do_family_rejection"), false) && (rejectFamilyHitAtRankExact = parameters.getInt(Configuration.dot("disambiguation", Configuration.PARAM_REJECTION_FAMILY_HIT_RANK_EXACT_MATCH))) + (rejectFamilyHitAtRankApprox = parameters.getInt(Configuration.dot("disambiguation", Configuration.PARAM_REJECTION_FAMILY_HIT_RANK_APPROX_MATCH))) > 0) {
            for (GeneMention gm : document.getNonRejectedGenesIterable()) {
                for (String taxId : gm.getTaxonomyIds()) {
                    if ((!gm.hasExactMatchInTax(taxId) || !gm.hasFamilyCandidateWithinRank(rejectFamilyHitAtRankExact, taxId)) && (gm.hasExactMatchInTax(taxId) || !gm.hasFamilyCandidateWithinRank(rejectFamilyHitAtRankApprox, taxId))) continue;
                    gm.getMentionMappingResult().setFinalRankedCandidates(taxId, List.of(MentionMappingResult.REJECTION));
                    gm.getMentionMappingResult().setRejectReason(taxId, MentionMappingResult.RejectReason.FOUND_FAMILY);
                }
            }
        }
    }

    public static void rejectFamilyInNp(GeneDocument document, Parameters parameters) {
        if (parameters.getBoolean(Configuration.dot("disambiguation", Configuration.PARAM_REJECT_FAMILY_IN_NP), false)) {
            for (GeneMention gm : document.getNonRejectedGenesIterable()) {
                Range npRange;
                String phrase;
                Optional anyNp = document.getOverlappingChunks(gm.getOffsets(), "ChunkNP").stream().findAny();
                if (!anyNp.isPresent() || !(phrase = document.getCoveredText(npRange = (Range)((Map.Entry)anyNp.get()).getKey())).toLowerCase().contains("family")) continue;
                for (String taxId : gm.getTaxonomyIds()) {
                    gm.getMentionMappingResult().setFinalRankedCandidates(taxId, List.of(MentionMappingResult.REJECTION));
                    gm.getMentionMappingResult().setRejectReason(taxId, MentionMappingResult.RejectReason.FAMILY_WORD_IN_NP);
                }
            }
        }
    }
}

