/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.composites;

import de.julielab.genemapper.composites.CompositePatternResolver;
import de.julielab.genemapper.composites.CompositeToken;
import de.julielab.genemapper.composites.ResolvedCompositeGeneName;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;

public class SlashDashAlternativePatternResolver
extends CompositePatternResolver {
    private final Pattern p = Pattern.compile("A+.*JA+.*(JA+.*)*");
    private final Pattern itemsP = Pattern.compile("A+[^J]*");

    @Override
    public String isEligible(String geneName) {
        return geneName.contains("/") || geneName.contains("-") ? this.getName() : null;
    }

    @Override
    public String matches(String tagging) {
        if (tagging.contains("C")) {
            return null;
        }
        Matcher m3 = this.p.matcher(tagging);
        return m3.matches() ? this.getName() : null;
    }

    @Override
    public List<ResolvedCompositeGeneName> resolve(String originalMention, Pair<List<CompositeToken>, String> tokenizedMentionAndTagging) {
        Matcher m3 = this.p.matcher(tokenizedMentionAndTagging.getRight());
        assert (m3.matches() && this.isEligible(originalMention) != null) : "Passed a pattern for resolution that does not match a case handled by this class. Use 'matches()' first to check the eligibility of the entity text.";
        List<CompositeToken> tokens = tokenizedMentionAndTagging.getLeft();
        ArrayList items = new ArrayList();
        Matcher itemsM = this.itemsP.matcher(tokenizedMentionAndTagging.getRight());
        while (itemsM.find()) {
            List item = IntStream.range(itemsM.start(), itemsM.end()).mapToObj(i -> (CompositeToken)tokens.get(i)).collect(Collectors.toList());
            items.add(item);
        }
        ArrayList<ResolvedCompositeGeneName> resolvedEnumerationMentions = new ArrayList<ResolvedCompositeGeneName>(items.size());
        for (List list : items) {
            ResolvedCompositeGeneName assembledLeftForm = new ResolvedCompositeGeneName(this.getClass());
            assembledLeftForm.addAll(list);
            resolvedEnumerationMentions.add(assembledLeftForm);
        }
        return resolvedEnumerationMentions;
    }
}

