/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.composites;

import de.julielab.genemapper.composites.CompositePatternResolver;
import de.julielab.genemapper.composites.CompositeToken;
import java.util.ArrayList;
import java.util.List;

public class ResolvedCompositeGeneName
extends ArrayList<CompositeToken> {
    private List<ResolvedCompositeGeneName> acronymForms;
    private final Class<? extends CompositePatternResolver> resolutionComponent;

    public ResolvedCompositeGeneName(Class<? extends CompositePatternResolver> resolutionComponent) {
        this.resolutionComponent = resolutionComponent;
    }

    public ResolvedCompositeGeneName(List<CompositeToken> tokens, Class<? extends CompositePatternResolver> resolutionComponent) {
        super(tokens);
        this.resolutionComponent = resolutionComponent;
    }

    public List<ResolvedCompositeGeneName> getAcronymForms() {
        return this.acronymForms;
    }

    public void addAcronymForm(ResolvedCompositeGeneName acronymForm) {
        if (this.acronymForms == null) {
            this.acronymForms = new ArrayList<ResolvedCompositeGeneName>();
        }
        this.acronymForms.add(acronymForm);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            CompositeToken token = (CompositeToken)this.get(i);
            if (token.isPlural() && token.getText().endsWith("s")) {
                sb.append(token.getText(), 0, token.getText().length() - 1);
            } else {
                sb.append(token.getText());
            }
            if (!token.isRightWs() || i >= this.size() - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getTagging() {
        char[] c = new char[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            c[i] = ((CompositeToken)this.get(i)).getTag();
        }
        return new String(c);
    }

    public Class<? extends CompositePatternResolver> getResolutionComponent() {
        return this.resolutionComponent;
    }

    public int getBegin() {
        return this.isEmpty() ? 0 : ((CompositeToken)this.get(0)).getBegin();
    }

    public int getEnd() {
        return this.isEmpty() ? 0 : ((CompositeToken)this.get(this.size() - 1)).getEnd();
    }
}

