/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.composites;

import de.julielab.genemapper.composites.CompositePatternResolver;
import de.julielab.genemapper.composites.CompositeToken;
import de.julielab.genemapper.composites.ResolvedCompositeGeneName;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternResolutionChain
extends CompositePatternResolver {
    private static final Logger log = LoggerFactory.getLogger(PatternResolutionChain.class);
    private final List<CompositePatternResolver> resolvers;

    public PatternResolutionChain(CompositePatternResolver ... resolvers) {
        this.resolvers = Arrays.asList(resolvers);
    }

    @Override
    public String isEligible(String geneName) {
        Optional<String> eligibleResolver = this.resolvers.stream().map(r -> r.isEligible(geneName)).filter(Objects::nonNull).findFirst();
        return eligibleResolver.isPresent() ? eligibleResolver.get() : null;
    }

    @Override
    public String matches(String tagging) {
        Optional<String> matchingResolver = this.resolvers.stream().map(r -> r.matches(tagging)).filter(Objects::nonNull).findFirst();
        return matchingResolver.isPresent() ? matchingResolver.get() : null;
    }

    @Override
    public List<ResolvedCompositeGeneName> resolve(String originalMention, Pair<List<CompositeToken>, String> tokenizedMentionAndTagging) {
        Optional<CompositePatternResolver> resolverOpt = this.resolvers.stream().filter(r -> r.isEligible(originalMention) != null).filter(r -> r.matches((String)tokenizedMentionAndTagging.getRight()) != null).findFirst();
        if (resolverOpt.isPresent()) {
            List<ResolvedCompositeGeneName> resolve = resolverOpt.get().resolve(originalMention, tokenizedMentionAndTagging);
            if (resolve.size() > 100) {
                log.warn("Gene composite name resolver '{}' resolved name '{}' to over 100 new names. This might be unwanted behaviour.", (Object)resolverOpt.get().getName(), (Object)originalMention);
            }
            if (resolve == null) {
                throw new IllegalStateException("Composite resolver did return a null result: " + resolverOpt.get().getName());
            }
            return resolve;
        }
        return Collections.emptyList();
    }
}

