/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.composites;

import de.julielab.genemapper.composites.CompositePatternResolver;
import de.julielab.genemapper.composites.CompositeToken;
import de.julielab.genemapper.composites.ResolvedCompositeGeneName;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class NumberElipseEnumerationPatternResolver
extends CompositePatternResolver {
    private final Pattern forwardPattern = Pattern.compile("(A+)(B[^EF]*[EF])?(O?S+CC?)+O?S+");
    private final Pattern backwardPattern = Pattern.compile("(S+O?CC?)+(S+)?O?(A+)(B[^EF]*[EF])?");
    private final Pattern backwardsParenthesis = Pattern.compile("O*(O?(S+CS+)+O?C?)+(S+)B?(S)[EF]?(A+)");
    private final Pattern specifierPattern = Pattern.compile("S+");

    @Override
    public String isEligible(String geneName) {
        String lcname = geneName.toLowerCase();
        return geneName.contains("/") || geneName.contains(" ") && (geneName.contains(",") || lcname.contains("and") || lcname.contains("or")) ? this.getName() : null;
    }

    @Override
    public String matches(String tagging) {
        Matcher forwardPatternMatcher = this.forwardPattern.matcher(tagging);
        Matcher backwardPatternMatcher = this.backwardPattern.matcher(tagging);
        Matcher backwardParenthesisMatcher = this.backwardsParenthesis.matcher(tagging);
        return forwardPatternMatcher.matches() || backwardPatternMatcher.matches() || backwardParenthesisMatcher.matches() ? this.getName() : null;
    }

    @Override
    public List<ResolvedCompositeGeneName> resolve(String originalMention, Pair<List<CompositeToken>, String> tokenizedMentionAndTagging) {
        String tagging = tokenizedMentionAndTagging.getRight();
        List<CompositeToken> tokens = tokenizedMentionAndTagging.getLeft();
        Matcher forwardPatternMatcher = this.forwardPattern.matcher(tagging);
        Matcher backwardPatternMatcher = this.backwardPattern.matcher(tagging);
        Matcher backwardParenthesisMatcher = this.backwardsParenthesis.matcher(tagging);
        Matcher specifierMatcher = this.specifierPattern.matcher(tagging);
        boolean forwardMatch = forwardPatternMatcher.matches();
        boolean backwardMatch = backwardPatternMatcher.matches();
        Matcher backwardParenthesisMatch = backwardParenthesisMatcher;
        assert ((forwardMatch || backwardMatch || backwardParenthesisMatch.matches()) && this.isEligible(originalMention) != null) : "Passed a pattern for resolution that does not match a case handled by this class. Use 'matches()' first to check the eligibility of the entity text.";
        List<ResolvedCompositeGeneName> resolvedEnumerationMentions = !backwardParenthesisMatch.matches() ? this.resolveEllipse(tokens, tagging, forwardPatternMatcher, backwardPatternMatcher, specifierMatcher, forwardMatch) : this.resolveEllipseWithParenthesis(tokens, tagging, backwardParenthesisMatch, specifierMatcher);
        return resolvedEnumerationMentions;
    }

    @NotNull
    private List<ResolvedCompositeGeneName> resolveEllipseWithParenthesis(List<CompositeToken> tokens, String tagging, Matcher backwardParenthesisMatcher, Matcher specifierMatcher) {
        List antecedent = IntStream.range(backwardParenthesisMatcher.start(5), tagging.length()).mapToObj(i -> (CompositeToken)tokens.get(i)).collect(Collectors.toList());
        ArrayList<ResolvedCompositeGeneName> resolvedEnumerationMentions = new ArrayList<ResolvedCompositeGeneName>();
        while (specifierMatcher.find()) {
            ResolvedCompositeGeneName assembledGeneName = new ResolvedCompositeGeneName(this.getClass());
            assembledGeneName.addAll(tokens.subList(specifierMatcher.start(), specifierMatcher.end()));
            assembledGeneName.forEach(t -> t.setRightWs(true));
            assembledGeneName.addAll(antecedent);
            resolvedEnumerationMentions.add(assembledGeneName);
        }
        return resolvedEnumerationMentions;
    }

    @NotNull
    private List<ResolvedCompositeGeneName> resolveEllipse(List<CompositeToken> tokens, String tagging, Matcher forwardPatternMatcher, Matcher backwardPatternMatcher, Matcher specifierMatcher, boolean forwardMatch) {
        String antecedentTagging;
        String string = antecedentTagging = forwardMatch ? forwardPatternMatcher.group(1) : backwardPatternMatcher.group(3);
        int stemLength = forwardMatch ? (forwardPatternMatcher.group(2) != null ? antecedentTagging.length() + forwardPatternMatcher.group(2).length() : antecedentTagging.length()) : antecedentTagging.length();
        List antecedent = forwardMatch ? IntStream.range(0, stemLength).mapToObj(i -> (CompositeToken)tokens.get(i)).collect(Collectors.toList()) : IntStream.range(backwardPatternMatcher.start(3), tagging.length()).mapToObj(i -> (CompositeToken)tokens.get(i)).collect(Collectors.toList());
        ArrayList<ResolvedCompositeGeneName> resolvedEnumerationMentions = new ArrayList<ResolvedCompositeGeneName>();
        while (specifierMatcher.find()) {
            ResolvedCompositeGeneName assembledGeneName = new ResolvedCompositeGeneName(this.getClass());
            if (forwardMatch) {
                assembledGeneName.addAll(antecedent);
            }
            assembledGeneName.addAll(tokens.subList(specifierMatcher.start(), specifierMatcher.end()));
            if (!forwardMatch) {
                assembledGeneName.addAll(antecedent);
            }
            resolvedEnumerationMentions.add(assembledGeneName);
        }
        return resolvedEnumerationMentions;
    }
}

