/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.composites;

import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneName;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.composites.CompositePatternResolver;
import de.julielab.genemapper.composites.CompositeToken;
import de.julielab.genemapper.composites.EmbeddedAcronymPatternResolver;
import de.julielab.genemapper.composites.EnumerationResolver;
import de.julielab.genemapper.composites.FlairCompositeMentionTagger;
import de.julielab.genemapper.composites.NumberElipseEnumerationPatternResolver;
import de.julielab.genemapper.composites.PatternResolutionChain;
import de.julielab.genemapper.composites.ResolvedCompositeGeneName;
import de.julielab.genemapper.composites.SlashDashAlternativePatternResolver;
import de.julielab.genemapper.composites.TwoPartedRangePatternResolver;
import de.julielab.genemapper.utils.GeneMapperException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneCompositeNameResolver {
    private static final Logger log = LoggerFactory.getLogger(GeneCompositeNameResolver.class);
    private final FlairCompositeMentionTagger compositeTagger;
    private final CompositePatternResolver patternResolver;

    @Inject
    public GeneCompositeNameResolver(FlairCompositeMentionTagger compositeTagger, Configuration configuration) throws GeneMapperException {
        this.compositeTagger = compositeTagger;
        this.patternResolver = new PatternResolutionChain(new SlashDashAlternativePatternResolver(), new TwoPartedRangePatternResolver(), new NumberElipseEnumerationPatternResolver(), new EmbeddedAcronymPatternResolver(), new EnumerationResolver());
    }

    public List<GeneMention> resolve(GeneMention gm, boolean ... print) throws GeneMapperException {
        try {
            ArrayList<GeneMention> identifiedGms = new ArrayList<GeneMention>();
            String firstEligible = this.patternResolver.isEligible(gm.getText());
            if (firstEligible != null) {
                List<ResolvedCompositeGeneName> recognizedNames;
                String firstMatching;
                Pair<List<CompositeToken>, String> tagging = this.compositeTagger.tagGeneMention(gm.getText(), gm.getOffsets(), gm.getGeneDocument());
                tagging = this.correctTagging(tagging);
                if (print.length > 0 && print[0]) {
                    System.out.println("Tagging: " + tagging.getRight());
                }
                if ((firstMatching = this.patternResolver.matches(tagging.getRight())) != null && (recognizedNames = this.patternResolver.resolve(gm.getText(), tagging)) != null) {
                    if (recognizedNames.size() > 100) {
                        log.warn("Gene name '{}' in document {} was resolved to over 100 new names. This might be unwanted behaviour.", (Object)gm.getText(), (Object)gm.getDocId());
                    }
                    try {
                        boolean isAtomic = false;
                        boolean sameComponentEligibleAndMatching = firstEligible.equals(firstMatching);
                        while (sameComponentEligibleAndMatching && !isAtomic && !recognizedNames.isEmpty()) {
                            ArrayList<ResolvedCompositeGeneName> listWithInternallyResolvedComposits = new ArrayList<ResolvedCompositeGeneName>();
                            for (int i = 0; i < recognizedNames.size(); ++i) {
                                List<ResolvedCompositeGeneName> internalResolution;
                                isAtomic = true;
                                ResolvedCompositeGeneName name = recognizedNames.get(i);
                                if (name != null && this.patternResolver.matches(name.getTagging()) != null && !(internalResolution = this.patternResolver.resolve(name.toString(), new ImmutablePair<List<CompositeToken>, String>(name, name.getTagging()))).isEmpty()) {
                                    listWithInternallyResolvedComposits.addAll(internalResolution);
                                    isAtomic = false;
                                    continue;
                                }
                                listWithInternallyResolvedComposits.add(name);
                            }
                            recognizedNames = listWithInternallyResolvedComposits;
                        }
                        if ((recognizedNames = recognizedNames.stream().filter(Objects::nonNull).collect(Collectors.toList())).size() > 1 || recognizedNames.size() == 1 && recognizedNames.get(0).getAcronymForms() != null) {
                            for (ResolvedCompositeGeneName resolvedGmName : recognizedNames) {
                                if (resolvedGmName == null) continue;
                                GeneMention identifiedGm = new GeneMention(gm);
                                identifiedGm.setOffsets(Range.between(gm.getBegin() + resolvedGmName.getBegin(), gm.getBegin() + resolvedGmName.getEnd()));
                                if (identifiedGm.hasGoldMentions()) {
                                    identifiedGm.setOverlappingGoldMentions(identifiedGm.getOverlappingGoldMentions().stream().filter(gold -> gold.getOffsets().isOverlappedBy(identifiedGm.getOffsets())).collect(Collectors.toList()));
                                }
                                identifiedGm.setText(resolvedGmName.toString());
                                identifiedGm.setTaxonomyId(gm.getTaxonomyId());
                                if (identifiedGm.getTaxonomyId() == null && gm.getTaxonomyIds() != null && !gm.getTaxonomyIds().isEmpty()) {
                                    identifiedGm.setTaxonomyId(gm.getTaxonomyIds().iterator().next());
                                }
                                identifiedGm.setTaxonomyIds(gm.getTaxonomyIds());
                                List<ResolvedCompositeGeneName> acronymForms = resolvedGmName.getAcronymForms();
                                if (acronymForms != null) {
                                    acronymForms.forEach(acronymForm -> identifiedGm.getGeneName().addAlternative(new GeneName(acronymForm.toString(), identifiedGm.getNormalizer())));
                                }
                                identifiedGm.setCompositeResolver(resolvedGmName.getResolutionComponent().getCanonicalName());
                                identifiedGms.add(identifiedGm);
                            }
                        }
                    }
                    catch (Throwable e) {
                        log.error("Composite resolution failed for {}. Tagging was: {}", (Object)gm, (Object)tagging);
                        throw new GeneMapperException(e);
                    }
                }
            }
            return identifiedGms.isEmpty() ? Collections.singletonList(gm) : identifiedGms;
        }
        catch (IOException | InterruptedException e) {
            throw new GeneMapperException(e);
        }
    }

    private Pair<List<CompositeToken>, String> correctTagging(Pair<List<CompositeToken>, String> tagging) {
        String postSpecifierText;
        String tags = tagging.getRight();
        List<CompositeToken> tokens = tagging.getLeft();
        if (tags.equals("SCAA")) {
            return new ImmutablePair<List<CompositeToken>, String>(tokens, "SCSA");
        }
        if (tags.matches("ASAA+") && (postSpecifierText = tokens.get(2).getText()).equals("-")) {
            return new ImmutablePair<List<CompositeToken>, String>(tokens, tags.replace("SA", "SJ"));
        }
        if (tags.matches(".*[EFB].*")) {
            StringBuilder newTagging = new StringBuilder();
            char[] reversed = new char[2];
            for (int i = 0; i < tags.length(); ++i) {
                char tag = tags.charAt(i);
                CompositeToken token = tokens.get(i);
                boolean tokenIsParenthesis = token.getText().matches("[]\\[()<>}\\{]");
                if (!(tag != 'E' && tag != 'F' && tag != 'B' || tokenIsParenthesis)) {
                    if (reversed[1] == '\u0000') {
                        reversed[1] = tag;
                    } else {
                        reversed[0] = tag;
                    }
                } else if ((tag == 'A' || tag == 'S') && tokenIsParenthesis) {
                    if (reversed[1] == '\u0000') {
                        reversed[1] = tag;
                    } else {
                        reversed[0] = tag;
                    }
                }
                if (reversed[0] == '\u0000' && reversed[1] == '\u0000') {
                    newTagging.append(tag);
                    continue;
                }
                if (reversed[0] == '\u0000' || reversed[1] == '\u0000') continue;
                newTagging.append(reversed[0]).append(reversed[1]);
                reversed[1] = '\u0000';
                reversed[0] = '\u0000';
            }
            if (newTagging.length() == tags.length()) {
                return new ImmutablePair<List<CompositeToken>, String>(tokens, newTagging.toString());
            }
        }
        return tagging;
    }

    public void shutdown() throws GeneMapperException {
        this.compositeTagger.shutdown();
    }
}

