/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.composites;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.PosTag;
import de.julielab.geneexpbase.services.CacheService;
import de.julielab.geneexpbase.services.ShutdownRequiring;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.composites.CompositeMentionTokenizer;
import de.julielab.genemapper.composites.CompositeToken;
import de.julielab.genemapper.utils.GeneMapperRuntimeException;
import de.julielab.ipc.javabridge.Options;
import de.julielab.ipc.javabridge.StdioBridge;
import de.julielab.java.utilities.IOStreamUtilities;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.cache.Cache;
import javax.inject.Inject;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlairCompositeMentionTagger
implements ShutdownRequiring {
    private static final Logger log = LoggerFactory.getLogger(FlairCompositeMentionTagger.class);
    private final BlockingQueue<StdioBridge<String>> bridges;
    private final ObjectMapper objectMapper;
    private final Cache<String, Pair<List<CompositeToken>, String>> taggingCache;
    private final JsonFactory jsonFactory;
    private final CompositeMentionTokenizer compositeTokenizer;

    @Inject
    public FlairCompositeMentionTagger(CacheService cacheService, Configuration configuration) throws IOException {
        String pythonExecutable = configuration.getProperty("python_executable", "python");
        String languageModelPath = configuration.getProperty("composite_flair_model");
        String flairGpuNum = configuration.getProperty("gpu_composite_mentions", "0");
        Options<String> params = new Options<String>(String.class);
        params.setExecutable(pythonExecutable);
        params.setExternalProgramReadySignal("Ready for tagging.");
        params.setExternalProgramTerminationSignal("exit");
        params.setTerminationSignalFromErrorStream("SyntaxError");
        String script = IOStreamUtilities.getStringFromInputStream(this.getClass().getResourceAsStream("/flairCompositeMentionResolution.py"));
        int numBridges = Integer.parseInt((String)configuration.getOrDefault((Object)"python_process_limit", "1"));
        this.bridges = new ArrayBlockingQueue<StdioBridge<String>>(numBridges);
        for (int i = 0; i < numBridges; ++i) {
            this.bridges.add(new StdioBridge<String>(params, "-u", "-c", script, languageModelPath, flairGpuNum));
        }
        this.jsonFactory = new JsonFactory();
        this.objectMapper = new ObjectMapper();
        this.compositeTokenizer = new CompositeMentionTokenizer();
        this.taggingCache = cacheService.getCacheManager().getCache("composite-mentions-cache");
    }

    public Pair<List<CompositeToken>, String> tagGeneMention(String untokenizedMention, Range<Integer> geneOffsets, GeneDocument geneDocument) throws IOException, InterruptedException {
        return this.tagGeneMention(Collections.singletonList(untokenizedMention), geneOffsets, geneDocument).get(0);
    }

    public List<Pair<List<CompositeToken>, String>> tagGeneMention(List<String> untokenizedMentions, Range<Integer> geneOffsets, GeneDocument geneDocument) throws IOException, InterruptedException {
        try {
            ArrayList<Pair<List<CompositeToken>, String>> ret = new ArrayList<Pair<List<CompositeToken>, String>>(untokenizedMentions.size());
            IntStream.range(0, untokenizedMentions.size()).forEach(i -> ret.add(null));
            ArrayList tokenizedMentions = new ArrayList(untokenizedMentions.size());
            StringWriter sw = new StringWriter();
            JsonGenerator generator = this.jsonFactory.createGenerator(sw);
            generator.writeStartArray();
            ArrayList<Integer> taggedIndices = new ArrayList<Integer>(untokenizedMentions.size());
            for (int i2 = 0; i2 < untokenizedMentions.size(); ++i2) {
                Pair<List<CompositeToken>, String> taggedMention = this.taggingCache.get(untokenizedMentions.get(i2));
                if (taggedMention != null) {
                    ret.set(i2, taggedMention);
                    continue;
                }
                taggedIndices.add(i2);
                List tokenized = this.compositeTokenizer.tokenize(untokenizedMentions.get(i2)).collect(Collectors.toList());
                tokenizedMentions.add(tokenized);
                try {
                    generator.writeStartObject();
                    generator.writeFieldName("sid");
                    generator.writeString(String.valueOf(i2));
                    generator.writeFieldName("text");
                    generator.writeString(tokenized.stream().map(CompositeToken::getText).collect(Collectors.joining(" ")));
                    generator.writeEndObject();
                    continue;
                }
                catch (IOException e) {
                    log.error("Could not write JSON", e);
                    throw new GeneMapperRuntimeException(e);
                }
            }
            generator.writeEndArray();
            generator.close();
            if (!taggedIndices.isEmpty()) {
                StdioBridge<String> bridge = this.bridges.take();
                if (!bridge.isRunning()) {
                    bridge.start();
                }
                Iterator response = bridge.sendAndReceive(sw.toString()).iterator();
                String[] mentionCompositeTaggings = null;
                if (response.hasNext()) {
                    String responseString = (String)response.next();
                    mentionCompositeTaggings = this.objectMapper.readValue(responseString, String[].class);
                }
                if (!this.bridges.offer(bridge)) {
                    throw new IllegalStateException("Could not put back an IO bridge.");
                }
                int taggedMentionsCounter = 0;
                for (int i3 = 0; i3 < mentionCompositeTaggings.length; ++i3) {
                    String mentionCompositeTagging = mentionCompositeTaggings[i3];
                    List tokenizedMention = (List)tokenizedMentions.get(i3);
                    for (int j = 0; j < tokenizedMention.size(); ++j) {
                        ((CompositeToken)tokenizedMention.get(j)).setTag(mentionCompositeTagging.charAt(j));
                    }
                    if (geneDocument != null && geneOffsets != null) {
                        for (CompositeToken token : tokenizedMention) {
                            Optional<PosTag> tokenPosOpt = geneDocument.getLastPosTag(Range.between(geneOffsets.getMinimum(), geneOffsets.getMinimum() + token.getEnd()), Collections.emptySet());
                            if (!tokenPosOpt.isPresent()) continue;
                            switch (tokenPosOpt.get().getTag()) {
                                case "NNS": {
                                    token.setPlural(true);
                                }
                            }
                        }
                    }
                    Integer mentionIndex = (Integer)taggedIndices.get(taggedMentionsCounter++);
                    ImmutablePair<List, String> taggedMention = new ImmutablePair<List, String>(tokenizedMention, mentionCompositeTagging);
                    ret.set(mentionIndex, taggedMention);
                    this.taggingCache.put(untokenizedMentions.get(mentionIndex), taggedMention);
                }
            }
            return ret;
        }
        catch (InterruptedException e) {
            log.error("Python communication was interrupted", e);
            throw e;
        }
        catch (IOException e) {
            log.error("IOException occurred", e);
            throw e;
        }
    }

    @Override
    public void shutdown() {
        try {
            for (StdioBridge stdioBridge : this.bridges) {
                if (!stdioBridge.isRunning()) continue;
                stdioBridge.stop();
            }
        }
        catch (IOException | InterruptedException e) {
            log.error("Exception while stopping external process", e);
        }
    }
}

