/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.composites;

import de.julielab.genemapper.composites.CompositePatternResolver;
import de.julielab.genemapper.composites.CompositeToken;
import de.julielab.genemapper.composites.ResolvedCompositeGeneName;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;

public class EnumerationResolver
extends CompositePatternResolver {
    private final Pattern taggingPattern = Pattern.compile("(A+S*)((J(A+S*))+)?(C|J)(A+S*)");
    private final Pattern enumerationPattern = Pattern.compile("A+S*");

    @Override
    public String isEligible(String geneName) {
        return geneName.contains("and") || geneName.contains("or") || geneName.contains(",") ? this.getName() : null;
    }

    @Override
    public String matches(String tagging) {
        return this.taggingPattern.matcher(tagging).matches() ? this.getName() : null;
    }

    @Override
    public List<ResolvedCompositeGeneName> resolve(String originalMention, Pair<List<CompositeToken>, String> tokenizedMentionAndTagging) {
        Matcher taggingPatternMatcher = this.taggingPattern.matcher(tokenizedMentionAndTagging.getRight());
        boolean matches = taggingPatternMatcher.matches();
        assert (matches && this.isEligible(originalMention) != null) : "Passed a pattern for resolution that does not match a case handled by this class. Use 'matches()' first to check the eligibility of the entity text.";
        ArrayList<ResolvedCompositeGeneName> resolvedMentions = new ArrayList<ResolvedCompositeGeneName>();
        List<CompositeToken> tokens = tokenizedMentionAndTagging.getLeft();
        int firstElementEnd = taggingPatternMatcher.end(1);
        ArrayList<List<CompositeToken>> enumerationTokens = new ArrayList<List<CompositeToken>>();
        String enumeration = taggingPatternMatcher.group(2);
        if (enumeration != null) {
            Matcher enumerationMatcher = this.enumerationPattern.matcher(enumeration);
            while (enumerationMatcher.find()) {
                enumerationTokens.add(tokens.subList(firstElementEnd + enumerationMatcher.start(), firstElementEnd + enumerationMatcher.end()));
            }
        }
        List<CompositeToken> firstElementTokens = tokens.subList(taggingPatternMatcher.start(1), firstElementEnd);
        List<CompositeToken> lastElementTokens = tokens.subList(taggingPatternMatcher.start(6), taggingPatternMatcher.end(6));
        resolvedMentions.add(new ResolvedCompositeGeneName(firstElementTokens, this.getClass()));
        enumerationTokens.stream().map(t -> new ResolvedCompositeGeneName((List<CompositeToken>)t, (Class<? extends CompositePatternResolver>)this.getClass())).forEach(resolvedMentions::add);
        resolvedMentions.add(new ResolvedCompositeGeneName(lastElementTokens, this.getClass()));
        return resolvedMentions;
    }
}

