/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.apps;

import com.google.inject.Guice;
import com.google.inject.Injector;
import de.julielab.gene.candidateretrieval.BooleanQueryGenerator;
import de.julielab.gene.candidateretrieval.CandidateRetrieval;
import de.julielab.gene.candidateretrieval.NameCentricRetrieval;
import de.julielab.gene.candidateretrieval.ioc.IndexModule;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.ioc.BaseModule;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.utils.GeneMapperException;
import de.julielab.genemapper.utils.GeneMapperInitializationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.search.BooleanClause;

public class InteractiveNameCentricCandidateFinder {
    public static void main(String[] args) throws IOException, GeneMapperException, GeneMapperInitializationException {
        String propertiesFile = "../built-resources/corpora/genemapper_interactive_candidate_finder.properties";
        Configuration configuration = new Configuration(new File(propertiesFile));
        Injector injector = Guice.createInjector(new BaseModule(configuration), new IndexModule(configuration));
        CandidateRetrieval luceneCandidateRetrieval = injector.getInstance(NameCentricRetrieval.class);
        TermNormalizer normalizer = injector.getInstance(TermNormalizer.class);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        block0: while (true) {
            System.out.println("Enter term:");
            String input = br.readLine();
            String normalizedTerm = normalizer.normalize(input);
            System.out.println("Normalized term: " + normalizedTerm);
            GeneMention geneMention = new GeneMention(input);
            String taxId = "3055";
            geneMention.setTaxonomyIds(List.of(taxId));
            geneMention.setNormalizer(normalizer);
            List<SynHit> candidates = luceneCandidateRetrieval.getCandidates(geneMention, Set.of("5726760", "5728451"), Set.of(), (QueryGenerator)new BooleanQueryGenerator(BooleanClause.Occur.SHOULD, -1));
            Iterator<SynHit> iterator = candidates.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                SynHit hit = iterator.next();
                System.out.println("Synonym: " + hit.getSynonym());
                System.out.println("    gene ID for given tax (" + taxId + "): " + hit.getGeneIdsOfTaxId(taxId).collect(Collectors.joining(", ")));
                System.out.println("    all gene IDs: " + hit.getIds());
                System.out.println("    all tax IDs:  " + hit.getTaxIds());
            }
            break;
        }
    }
}

