/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.apps;

import com.google.common.collect.Sets;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AppUtils {
    private AppUtils() {
    }

    public static void collectMatchingCandidates(Set<String> taxIds, List<SynHit> candidates, List<String> synonymsAndTax) {
        HashSet<String> taxIdsForSynonym = new HashSet<String>(candidates.get(0).getTaxIds());
        for (String taxId : Sets.intersection(taxIds, taxIdsForSynonym)) {
            synonymsAndTax.add(taxId);
        }
    }

    public static SynHit getCandidateForTaxId(List<SynHit> candidates, String taxId) {
        int i = 0;
        SynHit ret = null;
        while (ret == null && i < candidates.size()) {
            SynHit synHit = candidates.get(i);
            try {
                synHit.setTaxId(taxId);
                ret = synHit;
            }
            catch (IllegalArgumentException e) {
                ++i;
            }
        }
        return ret;
    }
}

