/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.services;

import de.julielab.geneexpbase.configuration.Configuration;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheService
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(CacheService.class);
    private CacheManager cacheManager;

    @Inject
    public CacheService(Configuration configuration) {
        this.init(configuration);
    }

    private void init(Configuration configuration) {
        CacheManager cacheManager;
        CachingProvider provider = Caching.getCachingProvider();
        try {
            String ehCacheConfigPath = configuration.getProperty("cache.ehcache.config");
            if (ehCacheConfigPath == null) {
                throw new IllegalArgumentException("There is no value for 'cache.ehcache.config' in the configuration file.");
            }
            URI ehCacheUri = null;
            File configFile = new File(ehCacheConfigPath);
            if (configFile.exists()) {
                ehCacheUri = configFile.toURI();
            } else {
                URL resourceUrl = this.getClass().getResource(ehCacheConfigPath);
                if (resourceUrl != null) {
                    ehCacheUri = resourceUrl.toURI();
                }
            }
            if (ehCacheUri == null) {
                throw new IllegalStateException("Could not find the ehcache configuration at " + ehCacheConfigPath);
            }
            log.debug("Initializing Ehcache from {}", (Object)ehCacheUri);
            cacheManager = provider.getCacheManager(ehCacheUri, this.getClass().getClassLoader());
        }
        catch (URISyntaxException e) {
            String msg = "Could not set up ehcache because the configuration was given in an invalid format.";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void close() {
        log.info("Closing CacheManager.");
        this.cacheManager.close();
        log.info("Cache manager successfully closed.");
    }
}

