/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.scoring;

import de.julielab.geneexpbase.scoring.Scorer;
import java.util.TreeSet;

public class SimpleScorer
extends Scorer {
    @Override
    public double getScore(String term1, String term2) {
        if (this.isPerfectMatch(term1, term2)) {
            return 9999.0;
        }
        String[] term1Elements = term1.split(" ");
        TreeSet<String> term1Set = new TreeSet<String>();
        for (int i = 0; i < term1Elements.length; ++i) {
            term1Set.add(term1Elements[i]);
        }
        String[] term2Elements = term2.split(" ");
        TreeSet<String> term2Set = new TreeSet<String>();
        for (int i = 0; i < term2Elements.length; ++i) {
            term2Set.add(term2Elements[i]);
        }
        int term1Size = term1Set.size();
        int term2Size = term2Set.size();
        term2Set.retainAll(term1Set);
        int intersectionSize = term2Set.size();
        double score = (double)intersectionSize / (double)term1Size * ((double)intersectionSize / (double)term2Size);
        return score;
    }

    public double getMaxLenDiffScore(String term1, String term2) {
        if (term1.equals(term2)) {
            return 1.0;
        }
        String[] term1Elements = term1.split(" ");
        TreeSet<String> term1Set = new TreeSet<String>();
        for (int i = 0; i < term1Elements.length; ++i) {
            term1Set.add(term1Elements[i]);
        }
        String[] term2Elements = term2.split(" ");
        TreeSet<String> term2Set = new TreeSet<String>();
        for (int i = 0; i < term2Elements.length; ++i) {
            term2Set.add(term2Elements[i]);
        }
        int term1Size = term1Set.size();
        int term2Size = term2Set.size();
        term2Set.retainAll(term1Set);
        int intersectionSize = term2Set.size();
        double lendiff1 = 0.0;
        double lendiff2 = 0.0;
        lendiff1 = term1Size - intersectionSize;
        lendiff2 = term2Size - intersectionSize;
        if (lendiff1 > lendiff2) {
            return lendiff1;
        }
        return lendiff2;
    }

    @Override
    public String info() {
        return "SimpleScorer";
    }

    public static void main(String[] args) {
        String s1 = "hemoglobin gamma a chain";
        String s2 = "hemoglobin gamma g";
        System.out.println(new SimpleScorer().getScore(s1, s2));
    }

    @Override
    public int getScorerType() {
        return 0;
    }
}

