/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.scoring;

import de.julielab.geneexpbase.scoring.Scorer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ScorerAvg
extends Scorer {
    private final Collection<Scorer> chain;
    private final String info;

    public ScorerAvg(Scorer ... scorers) {
        this(List.of(scorers));
    }

    public ScorerAvg(Collection<Scorer> scorers) {
        this.chain = scorers;
        this.info = this.chain.stream().map(Scorer::info).collect(Collectors.joining());
    }

    @Override
    public double getScore(String term1, String term2) throws RuntimeException {
        if (this.chain != null && !this.chain.isEmpty()) {
            return this.chain.stream().mapToDouble(s2 -> s2.getScore(term1, term2)).average().getAsDouble();
        }
        return 0.0;
    }

    @Override
    public String info() {
        return this.info;
    }

    @Override
    public int getScorerType() {
        return -1;
    }
}

