/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.scoring;

import com.wcohen.ss.AbstractStringDistance;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public abstract class Scorer {
    public static final Map<String, Long> SCORING_TIME = new HashMap<String, Long>();
    public static final int SIMPLE_SCORER = 0;
    public static final int TOKEN_JAROWINKLER_SCORER = 1;
    public static final int MAXENT_SCORER = 2;
    public static final int JAROWINKLER_SCORER = 3;
    public static final int LEVENSHTEIN_SCORER = 4;
    public static final int SMITHWATERMAN_SCORER = 5;
    public static final int NEEDLEMANWUNSCH_SCORER = 5;
    public static final int JACCARD_SCORER = 6;
    public static final int TFIDF = 5;
    public static final int LUCENE_SCORER = 10;
    @Deprecated
    public static final String MAPPING_CORE = "mapping_core";
    private static final Map<Triple<Integer, String, String>, Double> cache = new ConcurrentHashMap<Triple<Integer, String, String>, Double>();
    public static final double PERFECT_SCORE = 9999.0;

    public boolean isPerfectMatch(String term1, String term2) {
        if (null == term1 || null == term2) {
            return false;
        }
        term1 = term1.trim().replaceAll("[\\s ]+", " ");
        term2 = term2.trim().replaceAll("[\\s ]+", " ");
        return term1.equals(term2);
    }

    public abstract double getScore(String var1, String var2) throws RuntimeException;

    protected double computeAndCacheScore(String term1, String term2, BiFunction<String, String, Double> scoreFunction) {
        ImmutableTriple<Integer, String, String> key = new ImmutableTriple<Integer, String, String>(this.getScorerType(), term1, term2);
        Double score = cache.get(key);
        if (score == null) {
            long time = 0L;
            if (SCORING_TIME != null) {
                time = System.nanoTime();
            }
            score = scoreFunction.apply(term1, term2);
            if (SCORING_TIME != null) {
                SCORING_TIME.merge(this.info(), System.nanoTime() - time, Long::sum);
            }
            cache.put(key, score);
        }
        return score;
    }

    protected double computeAndCacheScore(String term1, String term2, AbstractStringDistance stringDistance) {
        return this.computeAndCacheScore(term1, term2, stringDistance::score);
    }

    public abstract String info();

    public abstract int getScorerType();

    public String toString() {
        return this.info();
    }
}

