/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.scoring;

import de.julielab.geneexpbase.scoring.Scorer;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class LevenshteinScorer
extends Scorer {
    @Override
    public double getScore(String term1, String term2) throws RuntimeException {
        return this.computeAndCacheScore(term1, term2, (String t1, String t2) -> {
            double distance = LevenshteinDistance.getDefaultInstance().apply((CharSequence)t1, (CharSequence)t2).intValue();
            double normalizedDistance = distance / Math.max((double)t1.length(), (double)t2.length());
            return 1.0 - normalizedDistance;
        });
    }

    @Override
    public String info() {
        return "NormalizedLevenshteinSimilarityScorer";
    }

    @Override
    public int getScorerType() {
        return 4;
    }
}

