/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.scoring;

import com.wcohen.ss.JaroWinkler;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.scoring.Scorer;

public class JaroWinklerScorer
extends Scorer {
    private final JaroWinkler scorer = new JaroWinkler();

    @Override
    public double getScore(String term1, String term2) {
        return this.computeAndCacheScore(term1, term2, (String t1, String t2) -> this.scorer.score((String)t1, (String)t2));
    }

    @Override
    public String info() {
        return "JaroWinklerScorer";
    }

    public static void main(String[] args) {
        TermNormalizer normalizer = new TermNormalizer();
        String t1 = "This gene is a member of the Antp homeobox family and encodes a protein with a homeobox DNA-binding domain. It is included in a cluster of homeobox B";
        String t2 = "homeobox";
        String n1 = normalizer.normalize(t1);
        String n2 = normalizer.normalize(t2);
        JaroWinklerScorer s2 = new JaroWinklerScorer();
        System.out.println("score " + n2 + ": " + ((Scorer)s2).getScore(n1, n2));
        n2 = normalizer.normalize("cluster");
        System.out.println("score " + n2 + ": " + ((Scorer)s2).getScore(n1, n2));
        n2 = normalizer.normalize("family");
        System.out.println("score " + n2 + ": " + ((Scorer)s2).getScore(n1, n2));
        n2 = normalizer.normalize("encodes");
        System.out.println("score " + n2 + ": " + ((Scorer)s2).getScore(n1, n2));
    }

    @Override
    public int getScorerType() {
        return 3;
    }
}

