/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.ioc;

import de.julielab.geneexpbase.services.ShutdownRequiring;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesShutdownHub {
    private static final Logger log = LoggerFactory.getLogger(ServicesShutdownHub.class);
    private final List<ShutdownRequiring> services = new ArrayList<ShutdownRequiring>();

    public void register(ShutdownRequiring service) {
        if (!this.services.contains(service)) {
            log.debug("Registering service {} for shutdown.", (Object)service);
            this.services.add(service);
        }
    }

    public void shutdown() {
        for (ShutdownRequiring service : this.services) {
            log.debug("Shutting down service {}", (Object)service);
            service.shutdown();
        }
    }
}

