/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.geneexpbase.ioc;

import com.google.inject.spi.ProvisionListener;
import de.julielab.geneexpbase.ioc.ServicesShutdownHub;
import de.julielab.geneexpbase.services.ShutdownRequiring;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleListener
implements ProvisionListener {
    private static final Logger log = LoggerFactory.getLogger(LifeCycleListener.class);
    private final List<Closeable> closeableServices;
    private Thread shutdownHook;
    private final ServicesShutdownHub shutdownHub;

    public LifeCycleListener(ServicesShutdownHub shutdownHub) {
        this.shutdownHub = shutdownHub;
        this.closeableServices = new ArrayList<Closeable>();
        this.addShutdownHook();
    }

    @Override
    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provisionInvocation) {
        T provision = provisionInvocation.provision();
        if (provision instanceof Closeable) {
            log.debug("Adding {} to services to be closed on application shutdown.", (Object)provision);
            this.closeableServices.add((Closeable)provision);
        } else if (provision instanceof ShutdownRequiring) {
            log.debug("Adding {} to services that require a manual shutdown.", (Object)provision);
            this.shutdownHub.register((ShutdownRequiring)provision);
        }
    }

    Thread getShutdownHook() {
        return this.shutdownHook;
    }

    private void addShutdownHook() {
        this.shutdownHook = new Thread(() -> {
            for (Closeable closable : this.closeableServices) {
                try {
                    log.debug("Closing {}", (Object)closable);
                    closable.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }
}

